/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.SinkMode;
import cascading.tap.SinkTap;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntrySchemeCollector;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTemplateTap<Config, Output>
extends SinkTap<Config, Output> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTemplateTap.class);
    protected static final int OPEN_TAPS_THRESHOLD_DEFAULT = 300;
    protected Tap parent;
    protected String pathTemplate;
    protected boolean keepParentOnDelete = false;
    protected int openTapsThreshold = 300;
    private final Map<String, TupleEntryCollector> collectors = new LinkedHashMap<String, TupleEntryCollector>(1000, 0.75f, true);

    protected abstract TupleEntrySchemeCollector createTupleEntrySchemeCollector(FlowProcess<Config> var1, Tap var2, String var3) throws IOException;

    public Tap getParent() {
        return this.parent;
    }

    public String getPathTemplate() {
        return this.pathTemplate;
    }

    @Override
    public String getIdentifier() {
        return this.parent.getIdentifier();
    }

    public int getOpenTapsThreshold() {
        return this.openTapsThreshold;
    }

    @Override
    public TupleEntryCollector openForWrite(FlowProcess<Config> flowProcess, Output output) throws IOException {
        return new TemplateCollector(flowProcess);
    }

    @Override
    public boolean createResource(Config conf) throws IOException {
        return this.parent.createResource(conf);
    }

    @Override
    public boolean deleteResource(Config conf) throws IOException {
        return this.keepParentOnDelete || this.parent.deleteResource(conf);
    }

    @Override
    public boolean commitResource(Config conf) throws IOException {
        return this.parent.commitResource(conf);
    }

    @Override
    public boolean rollbackResource(Config conf) throws IOException {
        return this.parent.rollbackResource(conf);
    }

    @Override
    public boolean resourceExists(Config conf) throws IOException {
        return this.parent.resourceExists(conf);
    }

    @Override
    public long getModifiedTime(Config conf) throws IOException {
        return this.parent.getModifiedTime(conf);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        BaseTemplateTap that = (BaseTemplateTap)object;
        if (this.parent != null ? !this.parent.equals(that.parent) : that.parent != null) {
            return false;
        }
        return !(this.pathTemplate != null ? !this.pathTemplate.equals(that.pathTemplate) : that.pathTemplate != null);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.parent != null ? this.parent.hashCode() : 0);
        result2 = 31 * result2 + (this.pathTemplate != null ? this.pathTemplate.hashCode() : 0);
        return result2;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[\"" + this.parent + "\"]" + "[\"" + this.pathTemplate + "\"]";
    }

    protected BaseTemplateTap(Tap parent, String pathTemplate, int openTapsThreshold) {
        this((Scheme<Config, ?, Output, ?, ?>)new TemplateScheme(parent.getScheme()));
        this.parent = parent;
        this.pathTemplate = pathTemplate;
        this.openTapsThreshold = openTapsThreshold;
    }

    protected BaseTemplateTap(Tap parent, String pathTemplate, SinkMode sinkMode) {
        super(new TemplateScheme(parent.getScheme()), sinkMode);
        this.parent = parent;
        this.pathTemplate = pathTemplate;
    }

    protected BaseTemplateTap(Tap parent, String pathTemplate, SinkMode sinkMode, boolean keepParentOnDelete, int openTapsThreshold) {
        super(new TemplateScheme(parent.getScheme()), sinkMode);
        this.parent = parent;
        this.pathTemplate = pathTemplate;
        this.keepParentOnDelete = keepParentOnDelete;
        this.openTapsThreshold = openTapsThreshold;
    }

    protected BaseTemplateTap(Tap parent, String pathTemplate, Fields pathFields, int openTapsThreshold) {
        super(new TemplateScheme(parent.getScheme(), pathFields));
        this.parent = parent;
        this.pathTemplate = pathTemplate;
        this.openTapsThreshold = openTapsThreshold;
    }

    protected BaseTemplateTap(Tap parent, String pathTemplate, Fields pathFields, SinkMode sinkMode) {
        super(new TemplateScheme(parent.getScheme(), pathFields), sinkMode);
        this.parent = parent;
        this.pathTemplate = pathTemplate;
    }

    protected BaseTemplateTap(Tap parent, String pathTemplate, Fields pathFields, SinkMode sinkMode, boolean keepParentOnDelete, int openTapsThreshold) {
        super(new TemplateScheme(parent.getScheme(), pathFields), sinkMode);
        this.parent = parent;
        this.pathTemplate = pathTemplate;
        this.keepParentOnDelete = keepParentOnDelete;
        this.openTapsThreshold = openTapsThreshold;
    }

    protected BaseTemplateTap(Scheme<Config, ?, Output, ?, ?> scheme, SinkMode sinkMode) {
        super(scheme, sinkMode);
    }

    protected BaseTemplateTap(Scheme<Config, ?, Output, ?, ?> scheme) {
        super(scheme);
    }

    public static class TemplateScheme<Config, Output>
    extends Scheme<Config, Void, Output, Void, Void> {
        private final Scheme scheme;
        private final Fields pathFields;

        public TemplateScheme(Scheme scheme) {
            this.scheme = scheme;
            this.pathFields = null;
        }

        public TemplateScheme(Scheme scheme, Fields pathFields) {
            this.scheme = scheme;
            if (pathFields == null || pathFields.isAll()) {
                this.pathFields = null;
            } else if (pathFields.isDefined()) {
                this.pathFields = pathFields;
            } else {
                throw new IllegalArgumentException("pathFields must be defined or the ALL substitution, got: " + pathFields.printVerbose());
            }
        }

        @Override
        public Fields getSinkFields() {
            if (this.pathFields == null || this.scheme.getSinkFields().isAll()) {
                return this.scheme.getSinkFields();
            }
            return Fields.merge(this.scheme.getSinkFields(), this.pathFields);
        }

        @Override
        public void setSinkFields(Fields sinkFields2) {
            this.scheme.setSinkFields(sinkFields2);
        }

        @Override
        public Fields getSourceFields() {
            return this.scheme.getSourceFields();
        }

        @Override
        public void setSourceFields(Fields sourceFields2) {
            this.scheme.setSourceFields(sourceFields2);
        }

        @Override
        public int getNumSinkParts() {
            return this.scheme.getNumSinkParts();
        }

        @Override
        public void setNumSinkParts(int numSinkParts) {
            this.scheme.setNumSinkParts(numSinkParts);
        }

        @Override
        public void sourceConfInit(FlowProcess<Config> flowProcess, Tap<Config, Void, Output> tap, Config conf) {
            this.scheme.sourceConfInit(flowProcess, tap, conf);
        }

        @Override
        public void sourcePrepare(FlowProcess<Config> flowProcess, SourceCall<Void, Void> sourceCall) throws IOException {
            this.scheme.sourcePrepare(flowProcess, sourceCall);
        }

        @Override
        public boolean source(FlowProcess<Config> flowProcess, SourceCall<Void, Void> sourceCall) throws IOException {
            throw new UnsupportedOperationException("not supported");
        }

        @Override
        public void sourceCleanup(FlowProcess<Config> flowProcess, SourceCall<Void, Void> sourceCall) throws IOException {
            this.scheme.sourceCleanup(flowProcess, sourceCall);
        }

        @Override
        public void sinkConfInit(FlowProcess<Config> flowProcess, Tap<Config, Void, Output> tap, Config conf) {
            this.scheme.sinkConfInit(flowProcess, tap, conf);
        }

        @Override
        public void sinkPrepare(FlowProcess<Config> flowProcess, SinkCall<Void, Output> sinkCall) throws IOException {
            this.scheme.sinkPrepare(flowProcess, sinkCall);
        }

        @Override
        public void sink(FlowProcess<Config> flowProcess, SinkCall<Void, Output> sinkCall) throws IOException {
            throw new UnsupportedOperationException("should never be called");
        }

        @Override
        public void sinkCleanup(FlowProcess<Config> flowProcess, SinkCall<Void, Output> sinkCall) throws IOException {
            this.scheme.sinkCleanup(flowProcess, sinkCall);
        }
    }

    public static enum Counters {
        Paths_Opened,
        Paths_Closed,
        Path_Purges;

    }

    private class TemplateCollector
    extends TupleEntryCollector {
        private final FlowProcess<Config> flowProcess;
        private final Config conf;
        private final Fields parentFields;
        private final Fields pathFields;

        public TemplateCollector(FlowProcess<Config> flowProcess) {
            super(Fields.asDeclaration(BaseTemplateTap.this.getSinkFields()));
            this.flowProcess = flowProcess;
            this.conf = flowProcess.getConfigCopy();
            this.parentFields = BaseTemplateTap.this.parent.getSinkFields();
            this.pathFields = ((TemplateScheme)BaseTemplateTap.this.getScheme()).pathFields;
        }

        private TupleEntryCollector getCollector(String path) {
            TupleEntryCollector collector = (TupleEntryCollector)BaseTemplateTap.this.collectors.get(path);
            if (collector != null) {
                return collector;
            }
            try {
                LOG.debug("creating collector for parent: {}, path: {}", (Object)BaseTemplateTap.this.parent.getFullIdentifier(this.conf), (Object)path);
                collector = BaseTemplateTap.this.createTupleEntrySchemeCollector(this.flowProcess, BaseTemplateTap.this.parent, path);
                this.flowProcess.increment(Counters.Paths_Opened, 1L);
            }
            catch (IOException exception) {
                throw new TapException("unable to open template path: " + path, exception);
            }
            if (BaseTemplateTap.this.collectors.size() > BaseTemplateTap.this.openTapsThreshold) {
                this.purgeCollectors();
            }
            BaseTemplateTap.this.collectors.put(path, collector);
            if (LOG.isInfoEnabled() && BaseTemplateTap.this.collectors.size() % 100 == 0) {
                LOG.info("caching {} open Taps", (Object)BaseTemplateTap.this.collectors.size());
            }
            return collector;
        }

        private void purgeCollectors() {
            int numToClose = Math.max(1, (int)((double)BaseTemplateTap.this.openTapsThreshold * 0.1));
            if (LOG.isInfoEnabled()) {
                LOG.info("removing {} open Taps from cache of size {}", (Object)numToClose, (Object)BaseTemplateTap.this.collectors.size());
            }
            HashSet<String> removeKeys = new HashSet<String>();
            Set keys2 = BaseTemplateTap.this.collectors.keySet();
            for (String key : keys2) {
                if (numToClose-- == 0) break;
                removeKeys.add(key);
            }
            for (String removeKey : removeKeys) {
                this.closeCollector((TupleEntryCollector)BaseTemplateTap.this.collectors.remove(removeKey));
            }
            this.flowProcess.increment(Counters.Path_Purges, 1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            super.close();
            try {
                for (TupleEntryCollector collector : BaseTemplateTap.this.collectors.values()) {
                    this.closeCollector(collector);
                }
            }
            finally {
                BaseTemplateTap.this.collectors.clear();
            }
        }

        private void closeCollector(TupleEntryCollector collector) {
            if (collector == null) {
                return;
            }
            try {
                collector.close();
                this.flowProcess.increment(Counters.Paths_Closed, 1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        protected void collect(TupleEntry tupleEntry) throws IOException {
            if (this.pathFields != null) {
                Tuple pathValues = tupleEntry.selectTuple(this.pathFields);
                String path = pathValues.format(BaseTemplateTap.this.pathTemplate);
                this.getCollector(path).add(tupleEntry.selectTuple(this.parentFields));
            } else {
                String path = tupleEntry.getTuple().format(BaseTemplateTap.this.pathTemplate);
                this.getCollector(path).add(tupleEntry);
            }
        }
    }
}

