/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats.local;

import cascading.flow.FlowStep;
import cascading.management.state.ClientState;
import cascading.stats.FlowStepStats;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public class LocalStepStats
extends FlowStepStats {
    final Map<String, Map<String, Long>> counters = new HashMap<String, Map<String, Long>>();

    public LocalStepStats(FlowStep<Properties> flowStep, ClientState clientState) {
        super(flowStep, clientState);
    }

    @Override
    public void recordChildStats() {
    }

    @Override
    public Collection<String> getCounterGroups() {
        return this.counters.keySet();
    }

    @Override
    public Collection<String> getCounterGroupsMatching(String regex) {
        Collection<String> counters2 = this.getCounterGroups();
        HashSet<String> results2 = new HashSet<String>();
        for (String counter2 : counters2) {
            if (!counter2.matches(regex)) continue;
            results2.add(counter2);
        }
        return Collections.unmodifiableCollection(results2);
    }

    @Override
    public Collection<String> getCountersFor(String group2) {
        Map<String, Long> groupCollection = this.counters.get(group2);
        if (groupCollection == null) {
            return Collections.emptySet();
        }
        return groupCollection.keySet();
    }

    @Override
    public long getCounterValue(Enum counter2) {
        Map<String, Long> counterMap2 = this.counters.get(counter2.getDeclaringClass().getName());
        String counterString = counter2.toString();
        if (counterMap2 == null || !counterMap2.containsKey(counterString)) {
            return 0L;
        }
        return counterMap2.get(counterString);
    }

    @Override
    public long getCounterValue(String group2, String counter2) {
        Map<String, Long> counterMap2 = this.counters.get(group2);
        if (counterMap2 == null || !counterMap2.containsKey(counter2)) {
            return 0L;
        }
        return counterMap2.get(counter2);
    }

    public void increment(Enum counter2, long amount) {
        this.increment(counter2.getDeclaringClass().getName(), counter2.toString(), amount);
    }

    public void increment(String group2, String counter2, long amount) {
        Map<String, Long> groupMap = this.getCreateCounter(group2);
        Long value2 = groupMap.get(counter2);
        if (value2 == null) {
            value2 = 0L;
        }
        groupMap.put(counter2, value2 + amount);
    }

    private Map<String, Long> getCreateCounter(String group2) {
        Map<String, Long> counterMap2 = this.counters.get(group2);
        if (counterMap2 == null) {
            counterMap2 = new HashMap<String, Long>();
            this.counters.put(group2, counterMap2);
        }
        return counterMap2;
    }

    @Override
    public void captureDetail() {
    }

    @Override
    public Collection getChildren() {
        return Collections.emptyList();
    }
}

