/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats.hadoop;

import cascading.CascadingException;
import cascading.flow.FlowStep;
import cascading.management.state.ClientState;
import cascading.stats.hadoop.BaseHadoopStepStats;
import cascading.stats.hadoop.HadoopSliceStats;
import cascading.util.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HadoopStepStats
extends BaseHadoopStepStats {
    private static final Logger LOG = LoggerFactory.getLogger(BaseHadoopStepStats.class);
    private Map<TaskID, String> idCache = new HashMap<TaskID, String>(4999);

    protected HadoopStepStats(FlowStep<JobConf> flowStep, ClientState clientState) {
        super(flowStep, clientState);
    }

    @Override
    protected void addTaskStats(Map<String, HadoopSliceStats> taskStats, HadoopSliceStats.Kind kind, boolean skipLast) throws IOException {
        TaskReport[] taskReports = this.retrieveTaskReports(kind);
        for (int i = 0; i < taskReports.length - (skipLast ? 1 : 0); ++i) {
            TaskReport taskReport = taskReports[i];
            if (taskReport == null) {
                LOG.warn("found empty task report");
                continue;
            }
            String id = this.getIDFor(taskReport.getTaskID());
            taskStats.put(id, new HadoopSliceStats(id, this.getStatus(), kind, this.stepHasReducers(), taskReport));
            this.incrementKind(kind);
        }
    }

    private TaskReport[] retrieveTaskReports(HadoopSliceStats.Kind kind) throws IOException {
        JobClient jobClient = this.getJobClient();
        RunningJob runningJob = this.getRunningJob();
        if (jobClient == null || runningJob == null) {
            return new TaskReport[0];
        }
        switch (kind) {
            case MAPPER: {
                return jobClient.getMapTaskReports(runningJob.getID());
            }
            case REDUCER: {
                return jobClient.getReduceTaskReports(runningJob.getID());
            }
            case CLEANUP: {
                return jobClient.getCleanupTaskReports(runningJob.getID());
            }
            case SETUP: {
                return jobClient.getSetupTaskReports(runningJob.getID());
            }
        }
        return new TaskReport[0];
    }

    @Override
    protected void addAttemptsToTaskStats(Map<String, HadoopSliceStats> taskStats, boolean captureAttempts) {
        RunningJob runningJob = this.getRunningJob();
        if (runningJob == null) {
            return;
        }
        int count2 = 0;
        while (captureAttempts) {
            try {
                TaskCompletionEvent[] events2 = runningJob.getTaskCompletionEvents(count2);
                if (events2.length == 0) break;
                for (TaskCompletionEvent event : events2) {
                    if (event == null) {
                        LOG.warn("found empty completion event");
                        continue;
                    }
                    HadoopSliceStats stats = taskStats.get(this.getIDFor(event.getTaskAttemptId().getTaskID()));
                    if (stats == null) continue;
                    stats.addAttempt(event);
                }
                count2 += events2.length;
            }
            catch (IOException exception) {
                throw new CascadingException(exception);
            }
        }
    }

    private String getIDFor(TaskID taskID) {
        String id = this.idCache.get(taskID);
        if (id == null) {
            id = Util.createUniqueID();
            this.idCache.put(taskID, id);
        }
        return id;
    }
}

