/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats.hadoop;

import cascading.stats.CascadingStats;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskReport;

public class HadoopSliceStats {
    private final CascadingStats.Status parentStatus;
    private String id;
    private Kind kind;
    private final boolean parentStepHasReducers;
    private TaskReport taskReport;
    private Map<String, Map<String, Long>> counters;
    private Map<Integer, HadoopAttempt> attempts = new HashMap<Integer, HadoopAttempt>();

    HadoopSliceStats(String id, CascadingStats.Status parentStatus, Kind kind, boolean parentStepHasReducers, TaskReport taskReport) {
        this.parentStatus = parentStatus;
        this.id = id;
        this.kind = kind;
        this.parentStepHasReducers = parentStepHasReducers;
        this.taskReport = taskReport;
    }

    public String getID() {
        return this.id;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getTaskID() {
        return this.taskReport.getTaskID().toString();
    }

    public int getTaskIDNum() {
        return this.taskReport.getTaskID().getId();
    }

    public String getJobID() {
        return this.taskReport.getTaskID().getJobID().toString();
    }

    public boolean parentStepHasReducers() {
        return this.parentStepHasReducers;
    }

    public float getProgress() {
        return this.taskReport.getProgress();
    }

    public String getState() {
        return this.taskReport.getState();
    }

    public long getStartTime() {
        return this.taskReport.getStartTime();
    }

    public long getFinishTime() {
        return this.taskReport.getFinishTime();
    }

    public CascadingStats.Status getParentStatus() {
        return this.parentStatus;
    }

    public CascadingStats.Status getStatus() {
        CascadingStats.Status status = null;
        switch (this.taskReport.getCurrentStatus()) {
            case PENDING: {
                status = CascadingStats.Status.PENDING;
                break;
            }
            case RUNNING: {
                status = CascadingStats.Status.RUNNING;
                break;
            }
            case COMPLETE: {
                status = CascadingStats.Status.SUCCESSFUL;
                break;
            }
            case KILLED: {
                status = CascadingStats.Status.STOPPED;
                break;
            }
            case FAILED: {
                status = CascadingStats.Status.FAILED;
            }
        }
        return status;
    }

    public String[] getDiagnostics() {
        return this.taskReport.getDiagnostics();
    }

    public Map<String, Map<String, Long>> getCounters() {
        if (this.counters == null) {
            this.setCounters(this.taskReport);
        }
        return this.counters;
    }

    public Map<Integer, HadoopAttempt> getAttempts() {
        return this.attempts;
    }

    private void setCounters(TaskReport taskReport) {
        this.counters = new HashMap<String, Map<String, Long>>();
        Counters hadoopCounters = taskReport.getCounters();
        for (Counters.Group group2 : hadoopCounters) {
            HashMap<String, Long> values2 = new HashMap<String, Long>();
            this.counters.put(group2.getName(), values2);
            for (Counters.Counter counter2 : group2) {
                values2.put(counter2.getName(), counter2.getCounter());
            }
        }
    }

    public long getCounterValue(Enum counter2) {
        return this.getCounterValue(counter2.getDeclaringClass().getName(), counter2.name());
    }

    public long getCounterValue(String group2, String name2) {
        if (this.getCounters() == null || this.getCounters().get(group2) == null) {
            return 0L;
        }
        Long value2 = this.getCounters().get(group2).get(name2);
        if (value2 == null) {
            return 0L;
        }
        return value2;
    }

    public void addAttempt(TaskCompletionEvent event) {
        this.attempts.put(event.getEventId(), new HadoopAttempt(event));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HadoopTaskStats");
        sb.append("{id='").append(this.id).append('\'');
        sb.append(", kind=").append((Object)this.kind);
        sb.append('}');
        return sb.toString();
    }

    public static enum Kind {
        SETUP,
        MAPPER,
        REDUCER,
        CLEANUP;

    }

    public static class HadoopAttempt {
        private final TaskCompletionEvent event;

        public HadoopAttempt(TaskCompletionEvent event) {
            this.event = event;
        }

        public int getEventId() {
            return this.event.getEventId();
        }

        public int getTaskRunTime() {
            return this.event.getTaskRunTime();
        }

        public String getTaskStatus() {
            return this.event.getTaskStatus().toString();
        }

        public String getTaskTrackerHttp() {
            return this.event.getTaskTrackerHttp();
        }

        public CascadingStats.Status getStatusFor() {
            CascadingStats.Status status = null;
            switch (this.event.getTaskStatus()) {
                case FAILED: {
                    status = CascadingStats.Status.FAILED;
                    break;
                }
                case KILLED: {
                    status = CascadingStats.Status.STOPPED;
                    break;
                }
                case SUCCEEDED: {
                    status = CascadingStats.Status.SUCCESSFUL;
                    break;
                }
                case OBSOLETE: {
                    status = CascadingStats.Status.SKIPPED;
                    break;
                }
                case TIPFAILED: {
                    status = CascadingStats.Status.FAILED;
                }
            }
            return status;
        }
    }
}

