/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats.hadoop;

import cascading.flow.FlowException;
import cascading.flow.FlowStep;
import cascading.management.state.ClientState;
import cascading.stats.FlowStepStats;
import cascading.stats.hadoop.HadoopSliceStats;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHadoopStepStats
extends FlowStepStats {
    public static final String COUNTER_TIMEOUT_PROPERTY = "cascading.step.counter.timeout";
    private static final Logger LOG = LoggerFactory.getLogger(BaseHadoopStepStats.class);
    public static final int TIMEOUT_MAX = 3;
    int numMapTasks;
    int numReduceTasks;
    private Counters cachedCounters = null;
    private int timeouts;
    Map<String, HadoopSliceStats> taskStats = Collections.EMPTY_MAP;
    private static ExecutorService futuresPool = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "stats-futures");
            thread.setDaemon(true);
            return thread;
        }
    });

    protected BaseHadoopStepStats(FlowStep<JobConf> flowStep, ClientState clientState) {
        super(flowStep, clientState);
    }

    public Map<String, HadoopSliceStats> getTaskStats() {
        return this.taskStats;
    }

    protected void setTaskStats(Map<String, HadoopSliceStats> taskStats) {
        this.taskStats = taskStats;
    }

    public int getNumMapTasks() {
        return this.numMapTasks;
    }

    void setNumMapTasks(int numMapTasks) {
        this.numMapTasks = numMapTasks;
    }

    public int getNumReduceTasks() {
        return this.numReduceTasks;
    }

    void setNumReduceTasks(int numReduceTasks) {
        this.numReduceTasks = numReduceTasks;
    }

    public String getJobID() {
        if (this.getRunningJob() == null) {
            return null;
        }
        return this.getRunningJob().getJobID();
    }

    public abstract JobClient getJobClient();

    public abstract RunningJob getRunningJob();

    @Override
    public Collection<String> getCounterGroups() {
        Counters counters2 = this.cachedCounters();
        if (counters2 == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(counters2.getGroupNames());
    }

    @Override
    public Collection<String> getCounterGroupsMatching(String regex) {
        Counters counters2 = this.cachedCounters();
        if (counters2 == null) {
            return Collections.emptySet();
        }
        HashSet<String> results2 = new HashSet<String>();
        for (String counter2 : counters2.getGroupNames()) {
            if (!counter2.matches(regex)) continue;
            results2.add(counter2);
        }
        return Collections.unmodifiableCollection(results2);
    }

    @Override
    public Collection<String> getCountersFor(String group2) {
        Counters counters2 = this.cachedCounters();
        if (counters2 == null) {
            return Collections.emptySet();
        }
        HashSet<String> results2 = new HashSet<String>();
        for (Counters.Counter counter2 : counters2.getGroup(group2)) {
            results2.add(counter2.getName());
        }
        return Collections.unmodifiableCollection(results2);
    }

    @Override
    public long getCounterValue(Enum counter2) {
        Counters counters2 = this.cachedCounters();
        if (counters2 == null) {
            return 0L;
        }
        return counters2.getCounter(counter2);
    }

    @Override
    public long getCounterValue(String group2, String counter2) {
        Counters counters2 = this.cachedCounters();
        if (counters2 == null) {
            return 0L;
        }
        Counters.Group counterGroup = counters2.getGroup(group2);
        if (group2 == null) {
            return 0L;
        }
        Counters.Counter counterValue = counterGroup.getCounterForName(counter2);
        if (counter2 == null) {
            return 0L;
        }
        return counterValue.getValue();
    }

    protected Counters cachedCounters() {
        return this.cachedCounters(false);
    }

    protected synchronized Counters cachedCounters(boolean force2) {
        if (!force2 && (this.isFinished() || this.timeouts >= 3)) {
            return this.cachedCounters;
        }
        RunningJob runningJob = this.getRunningJob();
        if (runningJob == null) {
            return this.cachedCounters;
        }
        Future<Counters> future = this.runFuture(runningJob);
        int timeout = ((JobConf)this.getFlowStep().getConfig()).getInt(COUNTER_TIMEOUT_PROPERTY, 5);
        try {
            Counters fetched = future.get(timeout, TimeUnit.SECONDS);
            if (fetched != null) {
                this.cachedCounters = fetched;
            }
        }
        catch (InterruptedException exception) {
            LOG.warn("fetching counters was interrupted");
        }
        catch (ExecutionException exception) {
            if (this.cachedCounters != null) {
                LOG.error("unable to get remote counters, returning cached values", exception.getCause());
                return this.cachedCounters;
            }
            LOG.error("unable to get remote counters, no cached values, throwing exception", exception.getCause());
            if (exception.getCause() instanceof FlowException) {
                throw (FlowException)exception.getCause();
            }
            throw new FlowException(exception.getCause());
        }
        catch (TimeoutException exception) {
            ++this.timeouts;
            if (this.timeouts >= 3) {
                LOG.warn("fetching counters timed out after: {} seconds, final attempt: {}", (Object)timeout, (Object)this.timeouts);
            }
            LOG.warn("fetching counters timed out after: {} seconds, attempts: {}", (Object)timeout, (Object)this.timeouts);
        }
        return this.cachedCounters;
    }

    private Future<Counters> runFuture(final RunningJob runningJob) {
        Callable<Counters> task = new Callable<Counters>(){

            @Override
            public Counters call() throws Exception {
                try {
                    return runningJob.getCounters();
                }
                catch (IOException exception) {
                    throw new FlowException("unable to get remote counter values");
                }
            }
        };
        return futuresPool.submit(task);
    }

    public float getMapProgress() {
        RunningJob runningJob = this.getRunningJob();
        if (runningJob == null) {
            return 0.0f;
        }
        try {
            return runningJob.mapProgress();
        }
        catch (IOException exception) {
            throw new FlowException("unable to get progress");
        }
    }

    public float getReduceProgress() {
        RunningJob runningJob = this.getRunningJob();
        if (runningJob == null) {
            return 0.0f;
        }
        try {
            return runningJob.reduceProgress();
        }
        catch (IOException exception) {
            throw new FlowException("unable to get progress");
        }
    }

    public String getStatusURL() {
        RunningJob runningJob = this.getRunningJob();
        if (runningJob == null) {
            return null;
        }
        return runningJob.getTrackingURL();
    }

    @Override
    public Collection getChildren() {
        return this.getTaskStats().values();
    }

    public Set<String> getChildIDs() {
        return this.getTaskStats().keySet();
    }

    @Override
    public synchronized void recordChildStats() {
        try {
            this.cachedCounters(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.clientState.isEnabled()) {
            return;
        }
        this.captureDetail();
        try {
            for (String id : this.taskStats.keySet()) {
                this.clientState.record(id, this.taskStats.get(id));
            }
        }
        catch (Exception exception) {
            LOG.error("unable to record slice stats", exception);
        }
    }

    @Override
    public synchronized void captureDetail() {
        this.captureDetail(true);
    }

    public void captureDetail(boolean captureAttempts) {
        HashMap<String, HadoopSliceStats> newStats = new HashMap<String, HadoopSliceStats>();
        JobClient jobClient = this.getJobClient();
        RunningJob runningJob = this.getRunningJob();
        if (jobClient == null || runningJob == null) {
            return;
        }
        this.numMapTasks = 0;
        this.numReduceTasks = 0;
        try {
            this.addTaskStats(newStats, HadoopSliceStats.Kind.MAPPER, false);
            this.addTaskStats(newStats, HadoopSliceStats.Kind.REDUCER, false);
            this.addAttemptsToTaskStats(newStats, captureAttempts);
            this.setTaskStats(newStats);
        }
        catch (IOException exception) {
            LOG.warn("unable to get task stats", exception);
        }
    }

    boolean stepHasReducers() {
        return !this.getFlowStep().getGroups().isEmpty();
    }

    void incrementKind(HadoopSliceStats.Kind kind) {
        switch (kind) {
            case SETUP: {
                break;
            }
            case MAPPER: {
                ++this.numMapTasks;
                break;
            }
            case REDUCER: {
                ++this.numReduceTasks;
                break;
            }
        }
    }

    protected abstract void addTaskStats(Map<String, HadoopSliceStats> var1, HadoopSliceStats.Kind var2, boolean var3) throws IOException;

    protected abstract void addAttemptsToTaskStats(Map<String, HadoopSliceStats> var1, boolean var2);
}

