/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats;

import cascading.flow.Flow;
import cascading.management.state.ClientState;
import cascading.property.AppProps;
import cascading.stats.CascadingStats;
import cascading.stats.FlowStepStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FlowStats
extends CascadingStats {
    final Flow flow;
    final List<FlowStepStats> flowStepStatsList = new ArrayList<FlowStepStats>();

    public FlowStats(Flow flow, ClientState clientState) {
        super(flow.getName(), clientState);
        this.flow = flow;
    }

    public Map<Object, Object> getFlowProperties() {
        return this.flow.getConfigAsProperties();
    }

    public String getAppID() {
        return AppProps.getApplicationID(this.getFlowProperties());
    }

    public String getAppName() {
        return AppProps.getApplicationName(this.getFlowProperties());
    }

    @Override
    public String getID() {
        return this.flow.getID();
    }

    @Override
    public synchronized void recordInfo() {
        this.clientState.recordFlow(this.flow);
    }

    public void addStepStats(FlowStepStats flowStepStats) {
        this.flowStepStatsList.add(flowStepStats);
    }

    public List<FlowStepStats> getFlowStepStats() {
        return this.flowStepStatsList;
    }

    public int getStepsCount() {
        return this.flowStepStatsList.size();
    }

    @Override
    public Collection<String> getCounterGroups() {
        HashSet<String> results2 = new HashSet<String>();
        for (FlowStepStats flowStepStats : this.flowStepStatsList) {
            results2.addAll(flowStepStats.getCounterGroups());
        }
        return results2;
    }

    @Override
    public Collection<String> getCounterGroupsMatching(String regex) {
        HashSet<String> results2 = new HashSet<String>();
        for (FlowStepStats flowStepStats : this.flowStepStatsList) {
            results2.addAll(flowStepStats.getCounterGroupsMatching(regex));
        }
        return results2;
    }

    @Override
    public Collection<String> getCountersFor(String group2) {
        HashSet<String> results2 = new HashSet<String>();
        for (FlowStepStats flowStepStats : this.flowStepStatsList) {
            results2.addAll(flowStepStats.getCountersFor(group2));
        }
        return results2;
    }

    @Override
    public long getCounterValue(Enum counter2) {
        long value2 = 0L;
        for (FlowStepStats flowStepStats : this.flowStepStatsList) {
            value2 += flowStepStats.getCounterValue(counter2);
        }
        return value2;
    }

    @Override
    public long getCounterValue(String group2, String counter2) {
        long value2 = 0L;
        for (FlowStepStats flowStepStats : this.flowStepStatsList) {
            value2 += flowStepStats.getCounterValue(group2, counter2);
        }
        return value2;
    }

    @Override
    public void captureDetail() {
        for (FlowStepStats flowStepStats : this.flowStepStatsList) {
            flowStepStats.captureDetail();
        }
    }

    @Override
    public Collection getChildren() {
        return this.getFlowStepStats();
    }

    @Override
    protected String getStatsString() {
        return super.getStatsString() + ", stepsCount=" + this.getStepsCount();
    }

    @Override
    public String toString() {
        return "Flow{" + this.getStatsString() + '}';
    }
}

