/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats;

import cascading.management.state.ClientState;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

public abstract class CascadingStats
implements Serializable {
    public static final String STATS_STORE_INTERVAL = "cascading.stats.store.interval";
    final String name;
    protected final ClientState clientState;
    Status status = Status.PENDING;
    long pendingTime;
    long startTime;
    long submitTime;
    long runTime;
    long finishedTime;
    Throwable throwable;

    public static void setStatsStoreInterval(Map<Object, Object> properties, long intervalMs) {
        if (intervalMs <= 0L) {
            throw new IllegalArgumentException("interval must be greater than zero, got: " + intervalMs);
        }
        properties.put(STATS_STORE_INTERVAL, Long.toString(intervalMs));
    }

    protected CascadingStats(String name2, ClientState clientState) {
        this.name = name2;
        this.clientState = clientState;
    }

    public void prepare() {
        this.clientState.startService();
    }

    public void cleanup() {
        this.clientState.stopService();
    }

    public abstract String getID();

    public String getName() {
        return this.name;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean isPending() {
        return this.status == Status.PENDING;
    }

    public boolean isSkipped() {
        return this.status == Status.SKIPPED;
    }

    public boolean isStarted() {
        return this.status == Status.STARTED;
    }

    public boolean isSubmitted() {
        return this.status == Status.SUBMITTED;
    }

    public boolean isRunning() {
        return this.status == Status.RUNNING;
    }

    public boolean isEngaged() {
        return this.isStarted() || this.isSubmitted() || this.isRunning();
    }

    public boolean isSuccessful() {
        return this.status == Status.SUCCESSFUL;
    }

    public boolean isFailed() {
        return this.status == Status.FAILED;
    }

    public boolean isStopped() {
        return this.status == Status.STOPPED;
    }

    public boolean isFinished() {
        return this.status == Status.SUCCESSFUL || this.status == Status.FAILED || this.status == Status.STOPPED || this.status == Status.SKIPPED;
    }

    public Status getStatus() {
        return this.status;
    }

    public void recordStats() {
        this.clientState.recordStats(this);
    }

    public abstract void recordInfo();

    public synchronized void markPending() {
        this.markPendingTime();
        this.recordStats();
        this.recordInfo();
    }

    protected void markPendingTime() {
        if (this.pendingTime == 0L) {
            this.pendingTime = System.currentTimeMillis();
        }
    }

    public synchronized void markStartedThenRunning() {
        if (this.status != Status.PENDING) {
            throw new IllegalStateException("may not mark as " + (Object)((Object)Status.STARTED) + ", is already " + (Object)((Object)this.status));
        }
        this.markStartToRunTime();
        this.markStarted();
        this.markRunning();
    }

    protected void markStartToRunTime() {
        this.submitTime = this.runTime = System.currentTimeMillis();
        this.startTime = this.runTime;
    }

    public synchronized void markStarted() {
        if (this.status != Status.PENDING) {
            throw new IllegalStateException("may not mark as " + (Object)((Object)Status.STARTED) + ", is already " + (Object)((Object)this.status));
        }
        this.status = Status.STARTED;
        this.markStartTime();
        this.clientState.start(this.startTime);
        this.clientState.setStatus(this.status, this.startTime);
        this.recordStats();
    }

    protected void markStartTime() {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
    }

    public synchronized void markSubmitted() {
        if (this.status == Status.SUBMITTED) {
            return;
        }
        if (this.status != Status.STARTED) {
            throw new IllegalStateException("may not mark as " + (Object)((Object)Status.SUBMITTED) + ", is already " + (Object)((Object)this.status));
        }
        this.status = Status.SUBMITTED;
        this.markSubmitTime();
        this.clientState.submit(this.submitTime);
        this.clientState.setStatus(this.status, this.submitTime);
        this.recordStats();
        this.recordInfo();
    }

    protected void markSubmitTime() {
        if (this.submitTime == 0L) {
            this.submitTime = System.currentTimeMillis();
        }
    }

    public synchronized void markRunning() {
        if (this.status == Status.RUNNING) {
            return;
        }
        if (this.status != Status.STARTED && this.status != Status.SUBMITTED) {
            throw new IllegalStateException("may not mark as " + (Object)((Object)Status.RUNNING) + ", is already " + (Object)((Object)this.status));
        }
        this.status = Status.RUNNING;
        this.markRunTime();
        this.clientState.run(this.runTime);
        this.clientState.setStatus(this.status, this.runTime);
        this.recordStats();
    }

    protected void markRunTime() {
        if (this.runTime == 0L) {
            this.runTime = System.currentTimeMillis();
        }
    }

    public synchronized void markSuccessful() {
        if (this.status != Status.RUNNING && this.status != Status.SUBMITTED) {
            throw new IllegalStateException("may not mark as " + (Object)((Object)Status.SUCCESSFUL) + ", is already " + (Object)((Object)this.status));
        }
        this.status = Status.SUCCESSFUL;
        this.markFinishedTime();
        this.clientState.setStatus(this.status, this.finishedTime);
        this.clientState.stop(this.finishedTime);
        this.recordStats();
        this.recordInfo();
    }

    private void markFinishedTime() {
        this.finishedTime = System.currentTimeMillis();
    }

    public synchronized void markFailed(Throwable throwable2) {
        if (this.status != Status.STARTED && this.status != Status.RUNNING && this.status != Status.SUBMITTED) {
            throw new IllegalStateException("may not mark as " + (Object)((Object)Status.FAILED) + ", is already " + (Object)((Object)this.status));
        }
        this.status = Status.FAILED;
        this.markFinishedTime();
        this.throwable = throwable2;
        this.clientState.setStatus(this.status, this.finishedTime);
        this.clientState.stop(this.finishedTime);
        this.recordStats();
        this.recordInfo();
    }

    public synchronized void markStopped() {
        if (this.status != Status.PENDING && this.status != Status.STARTED && this.status != Status.SUBMITTED && this.status != Status.RUNNING) {
            throw new IllegalStateException("may not mark as " + (Object)((Object)Status.STOPPED) + ", is already " + (Object)((Object)this.status));
        }
        this.status = Status.STOPPED;
        this.markFinishedTime();
        this.clientState.setStatus(this.status, this.finishedTime);
        this.recordStats();
        this.recordInfo();
        this.clientState.stop(this.finishedTime);
    }

    public synchronized void markSkipped() {
        if (this.status != Status.PENDING) {
            throw new IllegalStateException("may not mark as " + (Object)((Object)Status.SKIPPED) + ", is already " + (Object)((Object)this.status));
        }
        this.status = Status.SKIPPED;
        this.clientState.setStatus(this.status, System.currentTimeMillis());
        this.recordStats();
    }

    public long getPendingTime() {
        return this.pendingTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getSubmitTime() {
        return this.submitTime;
    }

    public long getRunTime() {
        return this.runTime;
    }

    public long getFinishedTime() {
        return this.finishedTime;
    }

    public long getDuration() {
        if (this.finishedTime != 0L) {
            return this.finishedTime - this.startTime;
        }
        return 0L;
    }

    public long getCurrentDuration() {
        if (this.finishedTime != 0L) {
            return this.finishedTime - this.startTime;
        }
        return System.currentTimeMillis() - this.startTime;
    }

    public abstract Collection<String> getCounterGroups();

    public abstract Collection<String> getCounterGroupsMatching(String var1);

    public abstract Collection<String> getCountersFor(String var1);

    public Collection<String> getCountersFor(Class<? extends Enum> group2) {
        return this.getCountersFor(group2.getName());
    }

    public abstract long getCounterValue(Enum var1);

    public abstract long getCounterValue(String var1, String var2);

    public abstract void captureDetail();

    public abstract Collection getChildren();

    protected String getStatsString() {
        String string2 = "status=" + (Object)((Object)this.status) + ", startTime=" + this.startTime;
        if (this.finishedTime != 0L) {
            string2 = string2 + ", duration=" + (this.finishedTime - this.startTime);
        }
        return string2;
    }

    public String toString() {
        return "Cascading{" + this.getStatsString() + '}';
    }

    public static enum Status {
        PENDING,
        SKIPPED,
        STARTED,
        SUBMITTED,
        RUNNING,
        SUCCESSFUL,
        STOPPED,
        FAILED;

    }
}

