/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats;

import cascading.cascade.Cascade;
import cascading.management.state.ClientState;
import cascading.stats.CascadingStats;
import cascading.stats.FlowStats;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class CascadeStats
extends CascadingStats {
    private Cascade cascade;
    final List<FlowStats> flowStatsList = new LinkedList<FlowStats>();

    public CascadeStats(Cascade cascade, ClientState clientState) {
        super(cascade.getName(), clientState);
        this.cascade = cascade;
    }

    @Override
    public String getID() {
        return this.cascade.getID();
    }

    @Override
    public synchronized void recordInfo() {
        this.clientState.recordCascade(this.cascade);
    }

    public void addFlowStats(FlowStats flowStats) {
        this.flowStatsList.add(flowStats);
    }

    public int getFlowCount() {
        return this.flowStatsList.size();
    }

    @Override
    public Collection<String> getCounterGroups() {
        HashSet<String> results2 = new HashSet<String>();
        for (FlowStats flowStats : this.flowStatsList) {
            results2.addAll(flowStats.getCounterGroups());
        }
        return results2;
    }

    @Override
    public Collection<String> getCounterGroupsMatching(String regex) {
        HashSet<String> results2 = new HashSet<String>();
        for (FlowStats flowStats : this.flowStatsList) {
            results2.addAll(flowStats.getCounterGroupsMatching(regex));
        }
        return results2;
    }

    @Override
    public Collection<String> getCountersFor(String group2) {
        HashSet<String> results2 = new HashSet<String>();
        for (FlowStats flowStats : this.flowStatsList) {
            results2.addAll(flowStats.getCountersFor(group2));
        }
        return results2;
    }

    @Override
    public long getCounterValue(Enum counter2) {
        long value2 = 0L;
        for (FlowStats flowStats : this.flowStatsList) {
            value2 += flowStats.getCounterValue(counter2);
        }
        return value2;
    }

    @Override
    public long getCounterValue(String group2, String counter2) {
        long value2 = 0L;
        for (FlowStats flowStats : this.flowStatsList) {
            value2 += flowStats.getCounterValue(group2, counter2);
        }
        return value2;
    }

    @Override
    public void captureDetail() {
        for (FlowStats flowStats : this.flowStatsList) {
            flowStats.captureDetail();
        }
    }

    @Override
    public Collection getChildren() {
        return this.flowStatsList;
    }

    @Override
    public String toString() {
        return "Cascade{flowStatsList=" + this.flowStatsList + '}';
    }
}

