/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme.util;

import cascading.flow.FlowProcess;
import cascading.scheme.util.FieldTypeResolver;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.CoercibleType;
import cascading.util.Util;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelimitedParser
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(DelimitedParser.class);
    static final String SPECIAL_REGEX_CHARS = "([\\]\\[|.*<>\\\\$^?()=!+])";
    static final String QUOTED_REGEX_FORMAT = "%2$s(?=(?:[^%1$s]*%1$s[^%1$s]*[^%1$s%2$s]*%1$s)*(?![^%1$s]*%1$s))";
    static final String CLEAN_REGEX_FORMAT = "^(?:%1$s)(.*)(?:%1$s)$";
    static final String ESCAPE_REGEX_FORMAT = "(%1$s%1$s)";
    protected Fields sourceFields;
    protected Pattern splitPattern;
    protected Pattern cleanPattern;
    protected Pattern escapePattern;
    protected String delimiter;
    protected String quote;
    protected boolean strict = true;
    protected boolean enforceStrict = true;
    protected int numValues;
    protected Type[] types;
    protected CoercibleType[] coercibles;
    protected boolean safe = true;
    protected FieldTypeResolver fieldTypeResolver;

    public DelimitedParser(String delimiter, String quote, Class[] types2) {
        this.reset(delimiter, quote, types2, this.strict, this.safe, null, null, null);
    }

    public DelimitedParser(String delimiter, String quote, Class[] types2, boolean strict, boolean safe) {
        this.reset(delimiter, quote, types2, strict, safe, null, null, null);
    }

    public DelimitedParser(String delimiter, String quote, FieldTypeResolver fieldTypeResolver) {
        this.reset(delimiter, quote, null, this.strict, this.safe, null, null, fieldTypeResolver);
    }

    public DelimitedParser(String delimiter, String quote, Class[] types2, boolean strict, boolean safe, FieldTypeResolver fieldTypeResolver) {
        this.reset(delimiter, quote, types2, strict, safe, null, null, fieldTypeResolver);
    }

    public DelimitedParser(String delimiter, String quote, Class[] types2, boolean strict, boolean safe, Fields sourceFields2, Fields sinkFields2) {
        this.reset(delimiter, quote, types2, strict, safe, sourceFields2, sinkFields2, null);
    }

    public DelimitedParser(String delimiter, String quote, Class[] types2, boolean strict, boolean safe, Fields sourceFields2, Fields sinkFields2, FieldTypeResolver fieldTypeResolver) {
        this.reset(delimiter, quote, types2, strict, safe, sourceFields2, sinkFields2, fieldTypeResolver);
    }

    public void reset(Fields sourceFields2, Fields sinkFields2) {
        this.reset(this.delimiter, this.quote, this.types, this.strict, this.safe, sourceFields2, sinkFields2, this.fieldTypeResolver);
    }

    public void reset(String delimiter, String quote, Type[] types2, boolean strict, boolean safe, Fields sourceFields2, Fields sinkFields2, FieldTypeResolver fieldTypeResolver) {
        if (delimiter == null || delimiter.isEmpty()) {
            throw new IllegalArgumentException("delimiter may not be null or empty");
        }
        if (delimiter.equals(quote)) {
            throw new IllegalArgumentException("delimiter and quote character may not be the same value, got: '" + delimiter + "'");
        }
        this.delimiter = delimiter;
        this.strict = strict;
        this.safe = safe;
        this.fieldTypeResolver = fieldTypeResolver;
        if (quote != null && !quote.isEmpty()) {
            this.quote = quote;
        }
        if (types2 != null && types2.length == 0) {
            this.types = null;
        }
        if (types2 != null) {
            this.types = Arrays.copyOf(types2, types2.length);
        }
        if (sourceFields2 == null || sinkFields2 == null) {
            return;
        }
        if (types2 == null && sourceFields2.hasTypes()) {
            this.types = sourceFields2.getTypes();
        }
        this.sourceFields = sourceFields2;
        this.numValues = Math.max(sourceFields2.size(), sinkFields2.size());
        this.enforceStrict = this.strict;
        if (sourceFields2.isUnknown()) {
            this.enforceStrict = false;
        }
        if (!sinkFields2.isAll() && this.numValues == 0) {
            throw new IllegalArgumentException("may not be zero declared fields, found: " + sinkFields2.printVerbose());
        }
        this.splitPattern = this.createSplitPatternFor(this.delimiter, this.quote);
        this.cleanPattern = this.createCleanPatternFor(this.quote);
        this.escapePattern = this.createEscapePatternFor(this.quote);
        if (this.types != null && sinkFields2.isAll()) {
            throw new IllegalArgumentException("when using Fields.ALL, field types may not be used");
        }
        if (this.types != null && this.types.length != sinkFields2.size()) {
            throw new IllegalArgumentException("num of types must equal number of fields: " + sinkFields2.printVerbose() + ", found: " + this.types.length);
        }
        this.coercibles = Coercions.coercibleArray(this.numValues, this.types);
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getQuote() {
        return this.quote;
    }

    public Pattern createEscapePatternFor(String quote) {
        if (quote == null || quote.isEmpty()) {
            return null;
        }
        return Pattern.compile(String.format(ESCAPE_REGEX_FORMAT, quote));
    }

    public Pattern createCleanPatternFor(String quote) {
        if (quote == null || quote.isEmpty()) {
            return null;
        }
        return Pattern.compile(String.format(CLEAN_REGEX_FORMAT, quote));
    }

    public Pattern createSplitPatternFor(String delimiter, String quote) {
        String escapedDelimiter = delimiter.replaceAll(SPECIAL_REGEX_CHARS, "\\\\$1");
        if (quote == null || quote.isEmpty()) {
            return Pattern.compile(escapedDelimiter);
        }
        return Pattern.compile(String.format(QUOTED_REGEX_FORMAT, quote, escapedDelimiter));
    }

    public String[] createSplit(String value2, Pattern splitPattern, int numValues) {
        return splitPattern.split(value2, numValues);
    }

    public Object[] cleanSplit(Object[] split2, Pattern cleanPattern, Pattern escapePattern, String quote) {
        int i;
        if (cleanPattern != null) {
            for (i = 0; i < split2.length; ++i) {
                split2[i] = cleanPattern.matcher((String)split2[i]).replaceAll("$1");
                split2[i] = escapePattern.matcher((String)split2[i]).replaceAll(quote);
            }
        }
        for (i = 0; i < split2.length; ++i) {
            if (!((String)split2[i]).isEmpty()) continue;
            split2[i] = null;
        }
        return split2;
    }

    public Fields parseFirstLine(FlowProcess flowProcess, Tap tap) {
        Fields sourceFields2;
        Closeable iterator2 = null;
        try {
            TupleEntry entry2;
            if (!tap.resourceExists(flowProcess.getConfigCopy())) {
                throw new TapException("unable to read fields from tap: " + tap + ", does not exist");
            }
            iterator2 = tap.openForRead(flowProcess);
            TupleEntry tupleEntry = entry2 = iterator2.hasNext() ? (TupleEntry)iterator2.next() : null;
            if (entry2 == null) {
                throw new TapException("unable to read fields from tap: " + tap + ", is empty");
            }
            Object[] result2 = this.onlyParseLine(entry2.getTuple().getString(0));
            result2 = this.cleanParsedLine(result2);
            Type[] inferred = this.inferTypes(result2);
            result2 = this.cleanFields(result2);
            sourceFields2 = new Fields((Comparable[])Arrays.copyOf(result2, result2.length, Comparable[].class));
            if (inferred != null) {
                sourceFields2 = sourceFields2.applyTypes(inferred);
            }
        }
        catch (IOException exception) {
            throw new TapException("unable to read fields from tap: " + tap, exception);
        }
        finally {
            if (iterator2 != null) {
                try {
                    iterator2.close();
                }
                catch (IOException exception) {}
            }
        }
        return sourceFields2;
    }

    public Object[] parseLine(String line) {
        Object[] split2 = this.onlyParseLine(line);
        split2 = this.cleanParsedLine(split2);
        return this.coerceParsedLine(line, split2);
    }

    protected Object[] cleanParsedLine(Object[] split2) {
        return this.cleanSplit(split2, this.cleanPattern, this.escapePattern, this.quote);
    }

    protected Object[] coerceParsedLine(String line, Object[] split2) {
        if (this.types != null) {
            Object[] result2 = new Object[split2.length];
            for (int i = 0; i < split2.length; ++i) {
                try {
                    result2[i] = this.coercibles[i].canonical(split2[i]);
                    continue;
                }
                catch (Exception exception) {
                    result2[i] = null;
                    if (!this.safe) {
                        throw new TapException(this.getSafeMessage(split2[i], i), exception, new Tuple(line));
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug(this.getSafeMessage(split2[i], i), exception);
                }
            }
            split2 = result2;
        }
        return split2;
    }

    private String getSafeMessage(Object object, int i) {
        try {
            return "field " + this.sourceFields.get(i) + " cannot be coerced from : " + object + " to: " + Util.getTypeName(this.types[i]);
        }
        catch (Throwable throwable2) {
            return "field pos " + i + " cannot be coerced from: " + object + ", pos has no corresponding field name or coercion type";
        }
    }

    protected Object[] onlyParseLine(String line) {
        Object[] split2 = this.createSplit(line, this.splitPattern, this.numValues == 0 ? 0 : -1);
        if (this.numValues != 0 && split2.length != this.numValues) {
            if (this.enforceStrict) {
                throw new TapException(this.getParseMessage(split2), new Tuple(line));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getParseMessage(split2));
            }
            Object[] array2 = new Object[this.numValues];
            Arrays.fill(array2, "");
            System.arraycopy(split2, 0, array2, 0, Math.min(this.numValues, split2.length));
            split2 = array2;
        }
        return split2;
    }

    private String getParseMessage(Object[] split2) {
        return "did not parse correct number of values from input data, expected: " + this.numValues + ", got: " + split2.length + ":" + Util.join(",", (String[])split2);
    }

    public Appendable joinFirstLine(Iterable iterable, Appendable buffer2) {
        iterable = this.prepareFields(iterable);
        return this.joinLine(iterable, buffer2);
    }

    public Appendable joinLine(Iterable iterable, Appendable buffer2) {
        try {
            if (this.quote != null) {
                return this.joinWithQuote(iterable, buffer2);
            }
            return this.joinNoQuote(iterable, buffer2);
        }
        catch (IOException exception) {
            throw new TapException("unable to append data", exception);
        }
    }

    protected Appendable joinWithQuote(Iterable tuple, Appendable buffer2) throws IOException {
        int count2 = 0;
        for (Object value2 : tuple) {
            if (count2 != 0) {
                buffer2.append(this.delimiter);
            }
            if (value2 != null) {
                String valueString = value2.toString();
                if (valueString.contains(this.quote)) {
                    valueString = valueString.replaceAll(this.quote, this.quote + this.quote);
                }
                if (valueString.contains(this.delimiter)) {
                    valueString = this.quote + valueString + this.quote;
                }
                buffer2.append(valueString);
            }
            ++count2;
        }
        return buffer2;
    }

    protected Appendable joinNoQuote(Iterable tuple, Appendable buffer2) throws IOException {
        int count2 = 0;
        for (Object value2 : tuple) {
            if (count2 != 0) {
                buffer2.append(this.delimiter);
            }
            if (value2 != null) {
                buffer2.append(value2.toString());
            }
            ++count2;
        }
        return buffer2;
    }

    protected Type[] inferTypes(Object[] result2) {
        if (this.fieldTypeResolver == null) {
            return null;
        }
        Type[] inferred = new Type[result2.length];
        for (int i = 0; i < result2.length; ++i) {
            String field2 = (String)result2[i];
            inferred[i] = this.fieldTypeResolver.inferTypeFrom(i, field2);
        }
        return inferred;
    }

    protected Iterable prepareFields(Iterable fields2) {
        if (this.fieldTypeResolver == null) {
            return fields2;
        }
        ArrayList result2 = new ArrayList();
        for (Object field2 : fields2) {
            Type type;
            int index2 = result2.size();
            String value2 = this.fieldTypeResolver.prepareField(index2, (String)field2, type = this.types != null ? this.types[index2] : null);
            if (value2 != null && !value2.isEmpty()) {
                field2 = value2;
            }
            result2.add(field2);
        }
        return result2;
    }

    protected Object[] cleanFields(Object[] result2) {
        if (this.fieldTypeResolver == null) {
            return result2;
        }
        for (int i = 0; i < result2.length; ++i) {
            Type type = this.types != null ? this.types[i] : null;
            String value2 = this.fieldTypeResolver.cleanField(i, (String)result2[i], type);
            if (value2 == null || value2.isEmpty()) continue;
            result2[i] = value2;
        }
        return result2;
    }
}

