/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme.local;

import cascading.flow.FlowProcess;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Properties;

public class TextLine
extends Scheme<Properties, InputStream, OutputStream, LineNumberReader, PrintWriter> {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private String charsetName = "UTF-8";

    public TextLine() {
        super(new Fields(new Comparable[]{"num", "line"}), Fields.ALL);
    }

    @ConstructorProperties(value={"sourceFields"})
    public TextLine(Fields sourceFields2) {
        super(sourceFields2);
        this.verify(sourceFields2);
    }

    @ConstructorProperties(value={"sourceFields", "charsetName"})
    public TextLine(Fields sourceFields2, String charsetName) {
        super(sourceFields2);
        this.setCharsetName(charsetName);
        this.verify(sourceFields2);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields"})
    public TextLine(Fields sourceFields2, Fields sinkFields2) {
        super(sourceFields2, sinkFields2);
        this.verify(sourceFields2);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields", "charsetName"})
    public TextLine(Fields sourceFields2, Fields sinkFields2, String charsetName) {
        super(sourceFields2, sinkFields2);
        this.setCharsetName(charsetName);
        this.verify(sourceFields2);
    }

    private void setCharsetName(String charsetName) {
        if (charsetName != null) {
            this.charsetName = charsetName;
        }
        Charset.forName(this.charsetName);
    }

    @Property(name="charset", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="character set used.")
    public String getCharsetName() {
        return this.charsetName;
    }

    protected void verify(Fields sourceFields2) {
        if (sourceFields2.size() < 1 || sourceFields2.size() > 2) {
            throw new IllegalArgumentException("this scheme requires either one or two source fields, given [" + sourceFields2 + "]");
        }
    }

    public LineNumberReader createInput(InputStream inputStream) {
        try {
            return new LineNumberReader(new InputStreamReader(inputStream, this.charsetName));
        }
        catch (UnsupportedEncodingException exception) {
            throw new TapException(exception);
        }
    }

    public PrintWriter createOutput(OutputStream outputStream) {
        try {
            return new PrintWriter(new OutputStreamWriter(outputStream, this.charsetName));
        }
        catch (UnsupportedEncodingException exception) {
            throw new TapException(exception);
        }
    }

    @Override
    public void presentSourceFields(FlowProcess<Properties> process2, Tap tap, Fields fields2) {
    }

    @Override
    public void presentSinkFields(FlowProcess<Properties> process2, Tap tap, Fields fields2) {
    }

    @Override
    public void sourceConfInit(FlowProcess<Properties> flowProcess, Tap<Properties, InputStream, OutputStream> tap, Properties conf) {
    }

    @Override
    public void sinkConfInit(FlowProcess<Properties> flowProcess, Tap<Properties, InputStream, OutputStream> tap, Properties conf) {
    }

    @Override
    public void sourcePrepare(FlowProcess<Properties> flowProcess, SourceCall<LineNumberReader, InputStream> sourceCall) throws IOException {
        sourceCall.setContext(this.createInput(sourceCall.getInput()));
    }

    @Override
    public boolean source(FlowProcess<Properties> flowProcess, SourceCall<LineNumberReader, InputStream> sourceCall) throws IOException {
        int lineNumber = sourceCall.getContext().getLineNumber();
        String line = sourceCall.getContext().readLine();
        if (line == null) {
            return false;
        }
        TupleEntry incomingEntry = sourceCall.getIncomingEntry();
        if (this.getSourceFields().size() == 1) {
            incomingEntry.setObject(Integer.valueOf(0), line);
        } else {
            incomingEntry.setInteger(Integer.valueOf(0), lineNumber);
            incomingEntry.setString(Integer.valueOf(1), line);
        }
        return true;
    }

    @Override
    public void sourceCleanup(FlowProcess<Properties> flowProcess, SourceCall<LineNumberReader, InputStream> sourceCall) throws IOException {
        sourceCall.setContext(null);
    }

    @Override
    public void sinkPrepare(FlowProcess<Properties> flowProcess, SinkCall<PrintWriter, OutputStream> sinkCall) throws IOException {
        sinkCall.setContext(this.createOutput(sinkCall.getOutput()));
    }

    @Override
    public void sink(FlowProcess<Properties> flowProcess, SinkCall<PrintWriter, OutputStream> sinkCall) throws IOException {
        sinkCall.getContext().println(sinkCall.getOutgoingEntry().getTuple().toString());
    }

    @Override
    public void sinkCleanup(FlowProcess<Properties> flowProcess, SinkCall<PrintWriter, OutputStream> sinkCall) throws IOException {
        sinkCall.getContext().flush();
        sinkCall.setContext(null);
    }
}

