/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme.local;

import cascading.flow.FlowProcess;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.scheme.local.TextLine;
import cascading.scheme.util.DelimitedParser;
import cascading.tap.CompositeTap;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tap.local.FileTap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.util.TupleViews;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Properties;

public class TextDelimited
extends Scheme<Properties, InputStream, OutputStream, LineNumberReader, PrintWriter> {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private final boolean skipHeader;
    private final boolean writeHeader;
    private final DelimitedParser delimitedParser;
    private String charsetName = "UTF-8";

    public TextDelimited() {
        this(Fields.ALL);
    }

    @ConstructorProperties(value={"hasHeader", "delimiter"})
    public TextDelimited(boolean hasHeader, String delimiter) {
        this(Fields.ALL, hasHeader, delimiter, null, (Class[])null);
    }

    @ConstructorProperties(value={"hasHeader", "delimiter", "quote"})
    public TextDelimited(boolean hasHeader, String delimiter, String quote) {
        this(Fields.ALL, hasHeader, delimiter, quote, (Class[])null);
    }

    @ConstructorProperties(value={"hasHeader", "delimitedParser"})
    public TextDelimited(boolean hasHeader, DelimitedParser delimitedParser) {
        this(Fields.ALL, hasHeader, hasHeader, delimitedParser);
    }

    @ConstructorProperties(value={"delimitedParser"})
    public TextDelimited(DelimitedParser delimitedParser) {
        this(Fields.ALL, true, true, delimitedParser);
    }

    @ConstructorProperties(value={"fields"})
    public TextDelimited(Fields fields2) {
        this(fields2, "\t", null, null);
    }

    @ConstructorProperties(value={"fields", "delimiter"})
    public TextDelimited(Fields fields2, String delimiter) {
        this(fields2, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter"})
    public TextDelimited(Fields fields2, boolean hasHeader, String delimiter) {
        this(fields2, hasHeader, hasHeader, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimiter"})
    public TextDelimited(Fields fields2, boolean skipHeader, boolean writeHeader, String delimiter) {
        this(fields2, skipHeader, writeHeader, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "delimiter", "types"})
    public TextDelimited(Fields fields2, String delimiter, Class[] types2) {
        this(fields2, delimiter, null, types2);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter", "types"})
    public TextDelimited(Fields fields2, boolean hasHeader, String delimiter, Class[] types2) {
        this(fields2, hasHeader, hasHeader, delimiter, null, types2);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimiter", "types"})
    public TextDelimited(Fields fields2, boolean skipHeader, boolean writeHeader, String delimiter, Class[] types2) {
        this(fields2, skipHeader, writeHeader, delimiter, null, types2);
    }

    @ConstructorProperties(value={"fields", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields2, String delimiter, String quote, Class[] types2) {
        this(fields2, false, delimiter, quote, types2);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields2, boolean hasHeader, String delimiter, String quote, Class[] types2) {
        this(fields2, hasHeader, hasHeader, delimiter, quote, types2, true);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields2, boolean skipHeader, boolean writeHeader, String delimiter, String quote, Class[] types2) {
        this(fields2, skipHeader, writeHeader, delimiter, quote, types2, true);
    }

    @ConstructorProperties(value={"fields", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields2, String delimiter, String quote, Class[] types2, boolean safe) {
        this(fields2, false, delimiter, quote, types2, safe);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields2, boolean hasHeader, String delimiter, String quote, Class[] types2, boolean safe) {
        this(fields2, hasHeader, hasHeader, delimiter, true, quote, types2, safe);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter", "quote", "types", "safe", "charsetName"})
    public TextDelimited(Fields fields2, boolean hasHeader, String delimiter, String quote, Class[] types2, boolean safe, String charsetName) {
        this(fields2, hasHeader, hasHeader, delimiter, true, quote, types2, safe, charsetName);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields2, boolean skipHeader, boolean writeHeader, String delimiter, String quote, Class[] types2, boolean safe) {
        this(fields2, skipHeader, writeHeader, delimiter, true, quote, types2, safe);
    }

    @ConstructorProperties(value={"fields", "delimiter", "quote"})
    public TextDelimited(Fields fields2, String delimiter, String quote) {
        this(fields2, false, delimiter, quote, null, true);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter", "quote"})
    public TextDelimited(Fields fields2, boolean hasHeader, String delimiter, String quote) {
        this(fields2, hasHeader, delimiter, quote, null, true);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter", "quote", "charsetName"})
    public TextDelimited(Fields fields2, boolean hasHeader, String delimiter, String quote, String charsetName) {
        this(fields2, hasHeader, delimiter, quote, null, true, charsetName);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimiter", "strict", "quote", "types", "safe"})
    public TextDelimited(Fields fields2, boolean skipHeader, boolean writeHeader, String delimiter, boolean strict, String quote, Class[] types2, boolean safe) {
        this(fields2, skipHeader, writeHeader, delimiter, strict, quote, types2, safe, DEFAULT_CHARSET);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimiter", "strict", "quote", "types", "safe", "charsetName"})
    public TextDelimited(Fields fields2, boolean skipHeader, boolean writeHeader, String delimiter, boolean strict, String quote, Class[] types2, boolean safe, String charsetName) {
        this(fields2, skipHeader, writeHeader, charsetName, new DelimitedParser(delimiter, quote, types2, strict, safe));
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimitedParser"})
    public TextDelimited(Fields fields2, boolean skipHeader, boolean writeHeader, DelimitedParser delimitedParser) {
        this(fields2, skipHeader, writeHeader, null, delimitedParser);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimitedParser"})
    public TextDelimited(Fields fields2, boolean hasHeader, DelimitedParser delimitedParser) {
        this(fields2, hasHeader, hasHeader, null, delimitedParser);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "charsetName", "delimitedParser"})
    public TextDelimited(Fields fields2, boolean skipHeader, boolean writeHeader, String charsetName, DelimitedParser delimitedParser) {
        super(fields2, fields2);
        this.delimitedParser = delimitedParser;
        this.setSourceFields(fields2);
        this.setSinkFields(fields2);
        this.skipHeader = skipHeader;
        this.writeHeader = writeHeader;
        if (charsetName != null) {
            this.charsetName = charsetName;
        }
        Charset.forName(this.charsetName);
    }

    @Property(name="charset", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="character set used.")
    public String getCharsetName() {
        return this.charsetName;
    }

    @Property(name="delimiter", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="The delimiter used to separate fields.")
    public String getDelimiter() {
        return this.delimitedParser.getDelimiter();
    }

    @Property(name="quote", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="The string used for quoting.")
    public String getQuote() {
        return this.delimitedParser.getQuote();
    }

    public LineNumberReader createInput(InputStream inputStream) {
        try {
            return new LineNumberReader(new InputStreamReader(inputStream, this.charsetName));
        }
        catch (UnsupportedEncodingException exception) {
            throw new TapException(exception);
        }
    }

    public PrintWriter createOutput(OutputStream outputStream) {
        try {
            return new PrintWriter(new OutputStreamWriter(outputStream, this.charsetName));
        }
        catch (UnsupportedEncodingException exception) {
            throw new TapException(exception);
        }
    }

    @Override
    public void setSinkFields(Fields sinkFields2) {
        super.setSourceFields(sinkFields2);
        super.setSinkFields(sinkFields2);
        if (this.delimitedParser != null) {
            this.delimitedParser.reset(this.getSourceFields(), this.getSinkFields());
        }
    }

    @Override
    public void setSourceFields(Fields sourceFields2) {
        super.setSourceFields(sourceFields2);
        super.setSinkFields(sourceFields2);
        if (this.delimitedParser != null) {
            this.delimitedParser.reset(this.getSourceFields(), this.getSinkFields());
        }
    }

    @Override
    public boolean isSymmetrical() {
        return super.isSymmetrical() && this.skipHeader == this.writeHeader;
    }

    @Override
    public Fields retrieveSourceFields(FlowProcess<Properties> process2, Tap tap) {
        if (!this.skipHeader || !this.getSourceFields().isUnknown()) {
            return this.getSourceFields();
        }
        if (tap instanceof CompositeTap) {
            tap = (Tap)((CompositeTap)((Object)tap)).getChildTaps().next();
        }
        tap = new FileTap(new TextLine(new Fields(new Comparable[]{"line"}), this.charsetName), tap.getIdentifier());
        this.setSourceFields(this.delimitedParser.parseFirstLine(process2, tap));
        return this.getSourceFields();
    }

    @Override
    public void presentSourceFields(FlowProcess<Properties> process2, Tap tap, Fields fields2) {
    }

    @Override
    public void presentSinkFields(FlowProcess<Properties> flowProcess, Tap tap, Fields fields2) {
        if (this.writeHeader) {
            this.presentSinkFieldsInternal(fields2);
        }
    }

    @Override
    public void sourceConfInit(FlowProcess<Properties> flowProcess, Tap<Properties, InputStream, OutputStream> tap, Properties conf) {
    }

    @Override
    public void sourcePrepare(FlowProcess<Properties> flowProcess, SourceCall<LineNumberReader, InputStream> sourceCall) throws IOException {
        sourceCall.setContext(this.createInput(sourceCall.getInput()));
        sourceCall.getIncomingEntry().setTuple(TupleViews.createObjectArray());
    }

    @Override
    public boolean source(FlowProcess<Properties> flowProcess, SourceCall<LineNumberReader, InputStream> sourceCall) throws IOException {
        String line = sourceCall.getContext().readLine();
        if (line == null) {
            return false;
        }
        if (this.skipHeader && sourceCall.getContext().getLineNumber() == 1) {
            line = sourceCall.getContext().readLine();
        }
        if (line == null) {
            return false;
        }
        Object[] split2 = this.delimitedParser.parseLine(line);
        Tuple tuple = sourceCall.getIncomingEntry().getTuple();
        TupleViews.reset(tuple, split2);
        return true;
    }

    @Override
    public void sourceCleanup(FlowProcess<Properties> flowProcess, SourceCall<LineNumberReader, InputStream> sourceCall) throws IOException {
        sourceCall.setContext(null);
    }

    @Override
    public void sinkConfInit(FlowProcess<Properties> flowProcess, Tap<Properties, InputStream, OutputStream> tap, Properties conf) {
    }

    @Override
    public void sinkPrepare(FlowProcess<Properties> flowProcess, SinkCall<PrintWriter, OutputStream> sinkCall) {
        sinkCall.setContext(this.createOutput(sinkCall.getOutput()));
        if (this.writeHeader) {
            Fields fields2 = sinkCall.getOutgoingEntry().getFields();
            this.delimitedParser.joinFirstLine(fields2, sinkCall.getContext());
            sinkCall.getContext().println();
        }
    }

    @Override
    public void sink(FlowProcess<Properties> flowProcess, SinkCall<PrintWriter, OutputStream> sinkCall) throws IOException {
        TupleEntry tupleEntry = sinkCall.getOutgoingEntry();
        Iterable<String> strings = tupleEntry.asIterableOf(String.class);
        this.delimitedParser.joinLine(strings, sinkCall.getContext());
        sinkCall.getContext().println();
    }

    @Override
    public void sinkCleanup(FlowProcess<Properties> flowProcess, SinkCall<PrintWriter, OutputStream> sinkCall) {
        sinkCall.getContext().flush();
        sinkCall.setContext(null);
    }
}

