/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme.hadoop;

import cascading.flow.FlowProcess;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.scheme.hadoop.SequenceFile;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import java.beans.ConstructorProperties;
import java.io.IOException;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;

public class WritableSequenceFile
extends SequenceFile {
    protected final Class<? extends Writable> keyType;
    protected final Class<? extends Writable> valueType;

    @ConstructorProperties(value={"fields", "valueType"})
    public WritableSequenceFile(Fields fields2, Class<? extends Writable> valueType) {
        this(fields2, null, valueType);
    }

    @ConstructorProperties(value={"fields", "keyType", "valueType"})
    public WritableSequenceFile(Fields fields2, Class<? extends Writable> keyType, Class<? extends Writable> valueType) {
        super(fields2);
        this.keyType = keyType;
        this.valueType = valueType;
        if (keyType == null && valueType == null) {
            throw new IllegalArgumentException("both keyType and valueType may not be null");
        }
        if (keyType == null && fields2.size() != 1) {
            throw new IllegalArgumentException("fields must declare exactly one field when only reading/writing 'keys' from a sequence file");
        }
        if (valueType == null && fields2.size() != 1) {
            throw new IllegalArgumentException("fields must declare exactly one field when only reading/writing 'values' from a sequence file");
        }
        if (keyType != null && valueType != null && fields2.size() != 2) {
            throw new IllegalArgumentException("fields must declare exactly two fields when only reading/writing 'keys' and 'values' from a sequence file");
        }
    }

    @Override
    public void sinkConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf conf) {
        if (this.keyType != null) {
            conf.setOutputKeyClass(this.keyType);
        } else {
            conf.setOutputKeyClass(NullWritable.class);
        }
        if (this.valueType != null) {
            conf.setOutputValueClass(this.valueType);
        } else {
            conf.setOutputValueClass(NullWritable.class);
        }
        conf.setOutputFormat(SequenceFileOutputFormat.class);
    }

    @Override
    public boolean source(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        Object key = sourceCall.getContext()[0];
        Object value2 = sourceCall.getContext()[1];
        boolean result2 = sourceCall.getInput().next(key, value2);
        if (!result2) {
            return false;
        }
        int count2 = 0;
        TupleEntry entry2 = sourceCall.getIncomingEntry();
        if (this.keyType != null) {
            entry2.setObject(Integer.valueOf(count2++), key);
        }
        if (this.valueType != null) {
            entry2.setObject(Integer.valueOf(count2), value2);
        }
        return true;
    }

    @Override
    public void sink(FlowProcess<JobConf> flowProcess, SinkCall<Void, OutputCollector> sinkCall) throws IOException {
        TupleEntry tupleEntry = sinkCall.getOutgoingEntry();
        NullWritable keyValue = NullWritable.get();
        NullWritable valueValue = NullWritable.get();
        if (this.keyType == null) {
            valueValue = (Writable)tupleEntry.getObject(0);
        } else if (this.valueType == null) {
            keyValue = (Writable)tupleEntry.getObject(0);
        } else {
            keyValue = (Writable)tupleEntry.getObject(0);
            valueValue = (Writable)tupleEntry.getObject(1);
        }
        sinkCall.getOutput().collect((Object)keyValue, (Object)valueValue);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WritableSequenceFile)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        WritableSequenceFile that = (WritableSequenceFile)object;
        if (this.keyType != null ? !this.keyType.equals(that.keyType) : that.keyType != null) {
            return false;
        }
        return !(this.valueType != null ? !this.valueType.equals(that.valueType) : that.valueType != null);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.keyType != null ? this.keyType.hashCode() : 0);
        result2 = 31 * result2 + (this.valueType != null ? this.valueType.hashCode() : 0);
        return result2;
    }
}

