/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme.hadoop;

import cascading.flow.FlowProcess;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;

public class TextLine
extends Scheme<JobConf, RecordReader, OutputCollector, Object[], Object[]> {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final long serialVersionUID = 1L;
    public static final Fields DEFAULT_SOURCE_FIELDS = new Fields(new Comparable[]{"offset", "line"});
    Compress sinkCompression = Compress.DISABLE;
    String charsetName = "UTF-8";

    public TextLine() {
        super(DEFAULT_SOURCE_FIELDS);
    }

    @ConstructorProperties(value={"numSinkParts"})
    public TextLine(int numSinkParts) {
        super(DEFAULT_SOURCE_FIELDS, numSinkParts);
    }

    @ConstructorProperties(value={"sinkCompression"})
    public TextLine(Compress sinkCompression) {
        super(DEFAULT_SOURCE_FIELDS);
        this.setSinkCompression(sinkCompression);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields"})
    public TextLine(Fields sourceFields2, Fields sinkFields2) {
        super(sourceFields2, sinkFields2);
        this.verify(sourceFields2);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields", "charsetName"})
    public TextLine(Fields sourceFields2, Fields sinkFields2, String charsetName) {
        super(sourceFields2, sinkFields2);
        this.setCharsetName(charsetName);
        this.verify(sourceFields2);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields", "numSinkParts"})
    public TextLine(Fields sourceFields2, Fields sinkFields2, int numSinkParts) {
        super(sourceFields2, sinkFields2, numSinkParts);
        this.verify(sourceFields2);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields", "sinkCompression"})
    public TextLine(Fields sourceFields2, Fields sinkFields2, Compress sinkCompression) {
        super(sourceFields2, sinkFields2);
        this.setSinkCompression(sinkCompression);
        this.verify(sourceFields2);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields", "sinkCompression", "charsetName"})
    public TextLine(Fields sourceFields2, Fields sinkFields2, Compress sinkCompression, String charsetName) {
        super(sourceFields2, sinkFields2);
        this.setSinkCompression(sinkCompression);
        this.setCharsetName(charsetName);
        this.verify(sourceFields2);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields", "sinkCompression", "numSinkParts"})
    public TextLine(Fields sourceFields2, Fields sinkFields2, Compress sinkCompression, int numSinkParts) {
        super(sourceFields2, sinkFields2, numSinkParts);
        this.setSinkCompression(sinkCompression);
        this.verify(sourceFields2);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields", "sinkCompression", "numSinkParts", "charsetName"})
    public TextLine(Fields sourceFields2, Fields sinkFields2, Compress sinkCompression, int numSinkParts, String charsetName) {
        super(sourceFields2, sinkFields2, numSinkParts);
        this.setSinkCompression(sinkCompression);
        this.setCharsetName(charsetName);
        this.verify(sourceFields2);
    }

    @ConstructorProperties(value={"sourceFields"})
    public TextLine(Fields sourceFields2) {
        super(sourceFields2);
        this.verify(sourceFields2);
    }

    @ConstructorProperties(value={"sourceFields", "charsetName"})
    public TextLine(Fields sourceFields2, String charsetName) {
        super(sourceFields2);
        this.setCharsetName(charsetName);
        this.verify(sourceFields2);
    }

    @ConstructorProperties(value={"sourceFields", "numSinkParts"})
    public TextLine(Fields sourceFields2, int numSinkParts) {
        super(sourceFields2, numSinkParts);
        this.verify(sourceFields2);
    }

    protected void setCharsetName(String charsetName) {
        if (charsetName != null) {
            this.charsetName = charsetName;
        }
        Charset.forName(this.charsetName);
    }

    @Property(name="charset", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="character set used in this scheme.")
    public String getCharsetName() {
        return this.charsetName;
    }

    protected void verify(Fields sourceFields2) {
        if (sourceFields2.size() < 1 || sourceFields2.size() > 2) {
            throw new IllegalArgumentException("this scheme requires either one or two source fields, given [" + sourceFields2 + "]");
        }
    }

    @Property(name="sinkCompression", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="The compression of the scheme when used in a sink.")
    public Compress getSinkCompression() {
        return this.sinkCompression;
    }

    public void setSinkCompression(Compress sinkCompression) {
        if (sinkCompression != null) {
            this.sinkCompression = sinkCompression;
        }
    }

    @Override
    public void sourceConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf conf) {
        if (this.hasZippedFiles(FileInputFormat.getInputPaths((JobConf)conf))) {
            throw new IllegalStateException("cannot read zip files: " + Arrays.toString(FileInputFormat.getInputPaths((JobConf)conf)));
        }
        conf.setInputFormat(TextInputFormat.class);
    }

    private boolean hasZippedFiles(Path[] paths) {
        if (paths == null || paths.length == 0) {
            return false;
        }
        boolean isZipped = paths[0].getName().endsWith(".zip");
        for (int i = 1; i < paths.length; ++i) {
            if (isZipped == paths[i].getName().endsWith(".zip")) continue;
            throw new IllegalStateException("cannot mix zipped and upzipped files");
        }
        return isZipped;
    }

    @Override
    public void presentSourceFields(FlowProcess<JobConf> flowProcess, Tap tap, Fields fields2) {
    }

    @Override
    public void presentSinkFields(FlowProcess<JobConf> flowProcess, Tap tap, Fields fields2) {
    }

    @Override
    public void sinkConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf conf) {
        if (tap.getFullIdentifier(conf).endsWith(".zip")) {
            throw new IllegalStateException("cannot write zip files: " + FileOutputFormat.getOutputPath((JobConf)conf));
        }
        if (this.getSinkCompression() == Compress.DISABLE) {
            conf.setBoolean("mapred.output.compress", false);
        } else if (this.getSinkCompression() == Compress.ENABLE) {
            conf.setBoolean("mapred.output.compress", true);
        }
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(Text.class);
        conf.setOutputFormat(TextOutputFormat.class);
    }

    @Override
    public void sourcePrepare(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) {
        if (sourceCall.getContext() == null) {
            sourceCall.setContext(new Object[3]);
        }
        sourceCall.getContext()[0] = sourceCall.getInput().createKey();
        sourceCall.getContext()[1] = sourceCall.getInput().createValue();
        sourceCall.getContext()[2] = Charset.forName(this.charsetName);
    }

    @Override
    public boolean source(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        if (!this.sourceReadInput(sourceCall)) {
            return false;
        }
        this.sourceHandleInput(sourceCall);
        return true;
    }

    private boolean sourceReadInput(SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        Object[] context = sourceCall.getContext();
        return sourceCall.getInput().next(context[0], context[1]);
    }

    protected void sourceHandleInput(SourceCall<Object[], RecordReader> sourceCall) {
        TupleEntry result2 = sourceCall.getIncomingEntry();
        int index2 = 0;
        Object[] context = sourceCall.getContext();
        if (this.getSourceFields().size() == 2) {
            result2.setLong(Integer.valueOf(index2++), ((LongWritable)context[0]).get());
        }
        result2.setString(Integer.valueOf(index2), this.makeEncodedString(context));
    }

    protected String makeEncodedString(Object[] context) {
        Text text2 = (Text)context[1];
        return new String(text2.getBytes(), 0, text2.getLength(), (Charset)context[2]);
    }

    @Override
    public void sourceCleanup(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) {
        sourceCall.setContext(null);
    }

    @Override
    public void sinkPrepare(FlowProcess<JobConf> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        sinkCall.setContext(new Object[2]);
        sinkCall.getContext()[0] = new Text();
        sinkCall.getContext()[1] = Charset.forName(this.charsetName);
    }

    @Override
    public void sink(FlowProcess<JobConf> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        Text text2 = (Text)sinkCall.getContext()[0];
        Charset charset = (Charset)sinkCall.getContext()[1];
        String line = sinkCall.getOutgoingEntry().getTuple().toString();
        text2.set(line.getBytes(charset));
        sinkCall.getOutput().collect(null, (Object)text2);
    }

    public static enum Compress {
        DEFAULT,
        ENABLE,
        DISABLE;

    }
}

