/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme.hadoop;

import cascading.flow.FlowProcess;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.scheme.hadoop.TextLine;
import cascading.scheme.util.DelimitedParser;
import cascading.tap.CompositeTap;
import cascading.tap.Tap;
import cascading.tap.hadoop.Hfs;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.util.TupleViews;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;

public class TextDelimited
extends TextLine {
    public static final String DEFAULT_CHARSET = "UTF-8";
    protected final DelimitedParser delimitedParser;
    private boolean skipHeader;
    private final boolean writeHeader;

    public TextDelimited() {
        this(Fields.ALL, null, "\t", null, null);
    }

    @ConstructorProperties(value={"hasHeader", "delimiter"})
    public TextDelimited(boolean hasHeader, String delimiter) {
        this(Fields.ALL, null, hasHeader, delimiter, null, (Class[])null);
    }

    @ConstructorProperties(value={"hasHeader", "delimiter", "quote"})
    public TextDelimited(boolean hasHeader, String delimiter, String quote) {
        this(Fields.ALL, null, hasHeader, delimiter, quote, (Class[])null);
    }

    @ConstructorProperties(value={"hasHeader", "delimitedParser"})
    public TextDelimited(boolean hasHeader, DelimitedParser delimitedParser) {
        this(Fields.ALL, null, hasHeader, hasHeader, delimitedParser);
    }

    @ConstructorProperties(value={"delimitedParser"})
    public TextDelimited(DelimitedParser delimitedParser) {
        this(Fields.ALL, null, true, true, delimitedParser);
    }

    @ConstructorProperties(value={"sinkCompression", "hasHeader", "delimitedParser"})
    public TextDelimited(TextLine.Compress sinkCompression, boolean hasHeader, DelimitedParser delimitedParser) {
        this(Fields.ALL, sinkCompression, hasHeader, hasHeader, delimitedParser);
    }

    @ConstructorProperties(value={"sinkCompression", "delimitedParser"})
    public TextDelimited(TextLine.Compress sinkCompression, DelimitedParser delimitedParser) {
        this(Fields.ALL, sinkCompression, true, true, delimitedParser);
    }

    @ConstructorProperties(value={"sinkCompression", "hasHeader", "delimiter", "quote"})
    public TextDelimited(TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, String quote) {
        this(Fields.ALL, sinkCompression, hasHeader, delimiter, quote, (Class[])null);
    }

    @ConstructorProperties(value={"fields"})
    public TextDelimited(Fields fields2) {
        this(fields2, null, "\t", null, null);
    }

    @ConstructorProperties(value={"fields", "delimiter"})
    public TextDelimited(Fields fields2, String delimiter) {
        this(fields2, null, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter"})
    public TextDelimited(Fields fields2, boolean hasHeader, String delimiter) {
        this(fields2, null, hasHeader, hasHeader, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimiter"})
    public TextDelimited(Fields fields2, boolean skipHeader, boolean writeHeader, String delimiter) {
        this(fields2, null, skipHeader, writeHeader, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "delimiter", "types"})
    public TextDelimited(Fields fields2, String delimiter, Class[] types2) {
        this(fields2, null, delimiter, null, types2);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter", "types"})
    public TextDelimited(Fields fields2, boolean hasHeader, String delimiter, Class[] types2) {
        this(fields2, null, hasHeader, hasHeader, delimiter, null, types2);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimiter", "types"})
    public TextDelimited(Fields fields2, boolean skipHeader, boolean writeHeader, String delimiter, Class[] types2) {
        this(fields2, null, skipHeader, writeHeader, delimiter, null, types2);
    }

    @ConstructorProperties(value={"fields", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields2, String delimiter, String quote, Class[] types2) {
        this(fields2, null, delimiter, quote, types2);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields2, boolean hasHeader, String delimiter, String quote, Class[] types2) {
        this(fields2, null, hasHeader, hasHeader, delimiter, quote, types2);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields2, boolean skipHeader, boolean writeHeader, String delimiter, String quote, Class[] types2) {
        this(fields2, null, skipHeader, writeHeader, delimiter, quote, types2);
    }

    @ConstructorProperties(value={"fields", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields2, String delimiter, String quote, Class[] types2, boolean safe) {
        this(fields2, null, delimiter, quote, types2, safe);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields2, boolean hasHeader, String delimiter, String quote, Class[] types2, boolean safe) {
        this(fields2, null, hasHeader, hasHeader, delimiter, quote, types2, safe);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter", "quote", "types", "safe", "charsetName"})
    public TextDelimited(Fields fields2, boolean hasHeader, String delimiter, String quote, Class[] types2, boolean safe, String charsetName) {
        this(fields2, null, hasHeader, hasHeader, delimiter, true, quote, types2, safe, charsetName);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields2, boolean skipHeader, boolean writeHeader, String delimiter, String quote, Class[] types2, boolean safe) {
        this(fields2, null, skipHeader, writeHeader, delimiter, quote, types2, safe);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, String delimiter) {
        this(fields2, sinkCompression, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter) {
        this(fields2, sinkCompression, hasHeader, hasHeader, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimiter"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter) {
        this(fields2, sinkCompression, skipHeader, writeHeader, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter", "types"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, String delimiter, Class[] types2) {
        this(fields2, sinkCompression, delimiter, null, types2);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter", "types"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, Class[] types2) {
        this(fields2, sinkCompression, hasHeader, hasHeader, delimiter, null, types2);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimiter", "types"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter, Class[] types2) {
        this(fields2, sinkCompression, skipHeader, writeHeader, delimiter, null, types2);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter", "types", "safe"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, String delimiter, Class[] types2, boolean safe) {
        this(fields2, sinkCompression, delimiter, null, types2, safe);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter", "types", "safe"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, Class[] types2, boolean safe) {
        this(fields2, sinkCompression, hasHeader, hasHeader, delimiter, null, types2, safe);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter", "types", "safe", "charsetName"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, Class[] types2, boolean safe, String charsetName) {
        this(fields2, sinkCompression, hasHeader, hasHeader, delimiter, true, null, types2, safe, charsetName);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimiter", "types", "safe"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter, Class[] types2, boolean safe) {
        this(fields2, sinkCompression, skipHeader, writeHeader, delimiter, null, types2, safe);
    }

    @ConstructorProperties(value={"fields", "delimiter", "quote"})
    public TextDelimited(Fields fields2, String delimiter, String quote) {
        this(fields2, null, delimiter, quote);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter", "quote"})
    public TextDelimited(Fields fields2, boolean hasHeader, String delimiter, String quote) {
        this(fields2, null, hasHeader, hasHeader, delimiter, quote);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimiter", "quote"})
    public TextDelimited(Fields fields2, boolean skipHeader, boolean writeHeader, String delimiter, String quote) {
        this(fields2, null, skipHeader, writeHeader, delimiter, quote);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter", "quote"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, String delimiter, String quote) {
        this(fields2, sinkCompression, false, false, delimiter, true, quote, null, true);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter", "quote"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, String quote) {
        this(fields2, sinkCompression, hasHeader, hasHeader, delimiter, true, quote, null, true);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter", "quote", "charsetName"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, String quote, String charsetName) {
        this(fields2, sinkCompression, hasHeader, hasHeader, delimiter, true, quote, null, true, charsetName);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimiter", "quote"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter, String quote) {
        this(fields2, sinkCompression, skipHeader, writeHeader, delimiter, true, quote, null, true);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, String delimiter, String quote, Class[] types2) {
        this(fields2, sinkCompression, false, false, delimiter, true, quote, types2, true);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, String quote, Class[] types2) {
        this(fields2, sinkCompression, hasHeader, hasHeader, delimiter, true, quote, types2, true);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter, String quote, Class[] types2) {
        this(fields2, sinkCompression, skipHeader, writeHeader, delimiter, true, quote, types2, true);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, String delimiter, String quote, Class[] types2, boolean safe) {
        this(fields2, sinkCompression, false, false, delimiter, true, quote, types2, safe);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, String quote, Class[] types2, boolean safe) {
        this(fields2, sinkCompression, hasHeader, hasHeader, delimiter, true, quote, types2, safe);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter, String quote, Class[] types2, boolean safe) {
        this(fields2, sinkCompression, skipHeader, writeHeader, delimiter, true, quote, types2, safe);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimiter", "strict", "quote", "types", "safe"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter, boolean strict, String quote, Class[] types2, boolean safe) {
        this(fields2, sinkCompression, skipHeader, writeHeader, delimiter, strict, quote, types2, safe, DEFAULT_CHARSET);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimiter", "strict", "quote", "types", "safe", "charsetName"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter, boolean strict, String quote, Class[] types2, boolean safe, String charsetName) {
        this(fields2, sinkCompression, skipHeader, writeHeader, charsetName, new DelimitedParser(delimiter, quote, types2, strict, safe));
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimitedParser"})
    public TextDelimited(Fields fields2, boolean skipHeader, boolean writeHeader, DelimitedParser delimitedParser) {
        this(fields2, null, skipHeader, writeHeader, null, delimitedParser);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimitedParser"})
    public TextDelimited(Fields fields2, boolean hasHeader, DelimitedParser delimitedParser) {
        this(fields2, null, hasHeader, hasHeader, null, delimitedParser);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimitedParser"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, DelimitedParser delimitedParser) {
        this(fields2, sinkCompression, skipHeader, writeHeader, null, delimitedParser);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "charsetName", "delimitedParser"})
    public TextDelimited(Fields fields2, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String charsetName, DelimitedParser delimitedParser) {
        super(sinkCompression);
        this.delimitedParser = delimitedParser;
        this.setSinkFields(fields2);
        this.setSourceFields(fields2);
        this.skipHeader = skipHeader;
        this.writeHeader = writeHeader;
        this.setCharsetName(charsetName);
    }

    @Property(name="delimiter", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="The delimiter used to separate fields.")
    public String getDelimiter() {
        return this.delimitedParser.getDelimiter();
    }

    @Property(name="quote", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="The string used for quoting.")
    public String getQuote() {
        return this.delimitedParser.getQuote();
    }

    @Override
    public boolean isSymmetrical() {
        return super.isSymmetrical() && this.skipHeader == this.writeHeader;
    }

    @Override
    public void setSinkFields(Fields sinkFields2) {
        super.setSourceFields(sinkFields2);
        super.setSinkFields(sinkFields2);
        if (this.delimitedParser != null) {
            this.delimitedParser.reset(this.getSourceFields(), this.getSinkFields());
        }
    }

    @Override
    public void setSourceFields(Fields sourceFields2) {
        super.setSourceFields(sourceFields2);
        super.setSinkFields(sourceFields2);
        if (this.delimitedParser != null) {
            this.delimitedParser.reset(this.getSourceFields(), this.getSinkFields());
        }
    }

    @Override
    public Fields retrieveSourceFields(FlowProcess<JobConf> flowProcess, Tap tap) {
        if (!this.skipHeader || !this.getSourceFields().isUnknown()) {
            return this.getSourceFields();
        }
        if (tap instanceof CompositeTap) {
            tap = (Tap)((CompositeTap)((Object)tap)).getChildTaps().next();
        }
        tap = new Hfs(new TextLine(new Fields(new Comparable[]{"line"}), this.charsetName), tap.getFullIdentifier(flowProcess.getConfigCopy()));
        this.setSourceFields(this.delimitedParser.parseFirstLine(flowProcess, tap));
        return this.getSourceFields();
    }

    @Override
    public void presentSourceFields(FlowProcess<JobConf> flowProcess, Tap tap, Fields fields2) {
        this.presentSourceFieldsInternal(fields2);
    }

    @Override
    public void presentSinkFields(FlowProcess<JobConf> flowProcess, Tap tap, Fields fields2) {
        this.presentSinkFieldsInternal(fields2);
    }

    @Override
    public void sourcePrepare(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) {
        super.sourcePrepare(flowProcess, sourceCall);
        sourceCall.getIncomingEntry().setTuple(TupleViews.createObjectArray());
    }

    @Override
    public boolean source(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        Object[] context = sourceCall.getContext();
        if (!sourceCall.getInput().next(context[0], context[1])) {
            return false;
        }
        if (this.skipHeader && ((LongWritable)context[0]).get() == 0L && !sourceCall.getInput().next(context[0], context[1])) {
            return false;
        }
        Object[] split2 = this.delimitedParser.parseLine(this.makeEncodedString(context));
        Tuple tuple = sourceCall.getIncomingEntry().getTuple();
        TupleViews.reset(tuple, split2);
        return true;
    }

    @Override
    public void sinkPrepare(FlowProcess<JobConf> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        sinkCall.setContext(new Object[3]);
        sinkCall.getContext()[0] = new Text();
        sinkCall.getContext()[1] = new StringBuilder(4096);
        sinkCall.getContext()[2] = Charset.forName(this.charsetName);
        if (this.writeHeader) {
            this.writeHeader(sinkCall);
        }
    }

    protected void writeHeader(SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        Fields fields2 = sinkCall.getOutgoingEntry().getFields();
        Text text2 = (Text)sinkCall.getContext()[0];
        StringBuilder line = (StringBuilder)sinkCall.getContext()[1];
        Charset charset = (Charset)sinkCall.getContext()[2];
        line = (StringBuilder)this.delimitedParser.joinFirstLine(fields2, line);
        text2.set(line.toString().getBytes(charset));
        sinkCall.getOutput().collect(null, (Object)text2);
        line.setLength(0);
    }

    @Override
    public void sink(FlowProcess<JobConf> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        TupleEntry tupleEntry = sinkCall.getOutgoingEntry();
        Text text2 = (Text)sinkCall.getContext()[0];
        StringBuilder line = (StringBuilder)sinkCall.getContext()[1];
        Charset charset = (Charset)sinkCall.getContext()[2];
        Iterable<String> strings = tupleEntry.asIterableOf(String.class);
        line = (StringBuilder)this.delimitedParser.joinLine(strings, line);
        text2.set(line.toString().getBytes(charset));
        sinkCall.getOutput().collect(null, (Object)text2);
        line.setLength(0);
    }
}

