/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme.hadoop;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.beans.ConstructorProperties;
import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;

public class SequenceFile
extends Scheme<JobConf, RecordReader, OutputCollector, Object[], Void> {
    protected SequenceFile() {
        super(null);
    }

    @ConstructorProperties(value={"fields"})
    public SequenceFile(Fields fields2) {
        super(fields2, fields2);
    }

    @Override
    public void sourceConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf conf) {
        conf.setInputFormat(SequenceFileInputFormat.class);
    }

    @Override
    public void sinkConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf conf) {
        conf.setOutputKeyClass(Tuple.class);
        conf.setOutputValueClass(Tuple.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
    }

    @Override
    public void sourcePrepare(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) {
        Object[] pair2 = new Object[]{sourceCall.getInput().createKey(), sourceCall.getInput().createValue()};
        sourceCall.setContext(pair2);
    }

    @Override
    public boolean source(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        Tuple key = (Tuple)sourceCall.getContext()[0];
        Tuple value2 = (Tuple)sourceCall.getContext()[1];
        boolean result2 = sourceCall.getInput().next((Object)key, (Object)value2);
        if (!result2) {
            return false;
        }
        TupleEntry entry2 = sourceCall.getIncomingEntry();
        if (entry2.hasTypes()) {
            entry2.setCanonicalTuple(value2);
        } else {
            entry2.setTuple(value2);
        }
        return true;
    }

    @Override
    public void sourceCleanup(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) {
        sourceCall.setContext(null);
    }

    @Override
    public void sink(FlowProcess<JobConf> flowProcess, SinkCall<Void, OutputCollector> sinkCall) throws IOException {
        sinkCall.getOutput().collect((Object)Tuple.NULL, (Object)sinkCall.getOutgoingEntry().getTuple());
    }
}

