/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme;

import cascading.flow.FlowProcess;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.util.TraceUtil;
import cascading.util.Traceable;
import java.io.IOException;
import java.io.Serializable;

public abstract class Scheme<Config, Input, Output, SourceContext, SinkContext>
implements Serializable,
Traceable {
    Fields sinkFields = Fields.ALL;
    Fields sourceFields = Fields.UNKNOWN;
    int numSinkParts;
    private String trace = TraceUtil.captureDebugTrace(this);

    protected Scheme() {
    }

    protected Scheme(Fields sourceFields2) {
        this.setSourceFields(sourceFields2);
    }

    protected Scheme(Fields sourceFields2, int numSinkParts) {
        this.setSourceFields(sourceFields2);
        this.numSinkParts = numSinkParts;
    }

    protected Scheme(Fields sourceFields2, Fields sinkFields2) {
        this.setSourceFields(sourceFields2);
        this.setSinkFields(sinkFields2);
    }

    protected Scheme(Fields sourceFields2, Fields sinkFields2, int numSinkParts) {
        this.setSourceFields(sourceFields2);
        this.setSinkFields(sinkFields2);
        this.numSinkParts = numSinkParts;
    }

    public Fields getSinkFields() {
        return this.sinkFields;
    }

    public void setSinkFields(Fields sinkFields2) {
        this.sinkFields = sinkFields2.isUnknown() ? Fields.ALL : sinkFields2;
    }

    public Fields getSourceFields() {
        return this.sourceFields;
    }

    public void setSourceFields(Fields sourceFields2) {
        this.sourceFields = sourceFields2.isAll() ? Fields.UNKNOWN : sourceFields2;
    }

    public int getNumSinkParts() {
        return this.numSinkParts;
    }

    public void setNumSinkParts(int numSinkParts) {
        this.numSinkParts = numSinkParts;
    }

    @Override
    public String getTrace() {
        return this.trace;
    }

    public boolean isSymmetrical() {
        return this.getSourceFields().equals(Fields.UNKNOWN) && this.getSinkFields().equals(Fields.ALL) || this.getSinkFields().equals(this.getSourceFields());
    }

    public boolean isSource() {
        return true;
    }

    public boolean isSink() {
        return true;
    }

    public Fields retrieveSourceFields(FlowProcess<Config> flowProcess, Tap tap) {
        return this.getSourceFields();
    }

    public void presentSourceFields(FlowProcess<Config> flowProcess, Tap tap, Fields fields2) {
        this.presentSourceFieldsInternal(fields2);
    }

    protected void presentSourceFieldsInternal(Fields fields2) {
        if (this.getSourceFields().equals(Fields.UNKNOWN)) {
            this.setSourceFields(fields2);
        }
    }

    public Fields retrieveSinkFields(FlowProcess<Config> flowProcess, Tap tap) {
        return this.getSinkFields();
    }

    public void presentSinkFields(FlowProcess<Config> flowProcess, Tap tap, Fields fields2) {
        this.presentSinkFieldsInternal(fields2);
    }

    protected void presentSinkFieldsInternal(Fields fields2) {
        if (this.getSinkFields().equals(Fields.ALL)) {
            this.setSinkFields(fields2);
        }
    }

    public abstract void sourceConfInit(FlowProcess<Config> var1, Tap<Config, Input, Output> var2, Config var3);

    public abstract void sinkConfInit(FlowProcess<Config> var1, Tap<Config, Input, Output> var2, Config var3);

    public void sourcePrepare(FlowProcess<Config> flowProcess, SourceCall<SourceContext, Input> sourceCall) throws IOException {
    }

    public abstract boolean source(FlowProcess<Config> var1, SourceCall<SourceContext, Input> var2) throws IOException;

    public void sourceCleanup(FlowProcess<Config> flowProcess, SourceCall<SourceContext, Input> sourceCall) throws IOException {
    }

    public void sinkPrepare(FlowProcess<Config> flowProcess, SinkCall<SinkContext, Output> sinkCall) throws IOException {
    }

    public abstract void sink(FlowProcess<Config> var1, SinkCall<SinkContext, Output> var2) throws IOException;

    public void sinkCleanup(FlowProcess<Config> flowProcess, SinkCall<SinkContext, Output> sinkCall) throws IOException {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Scheme scheme = (Scheme)object;
        if (this.numSinkParts != scheme.numSinkParts) {
            return false;
        }
        if (this.sinkFields != null ? !this.sinkFields.equals(scheme.sinkFields) : scheme.sinkFields != null) {
            return false;
        }
        return !(this.sourceFields != null ? !this.sourceFields.equals(scheme.sourceFields) : scheme.sourceFields != null);
    }

    public String toString() {
        if (this.getSinkFields().equals(this.getSourceFields())) {
            return this.getClass().getSimpleName() + "[" + this.getSourceFields().print() + "]";
        }
        return this.getClass().getSimpleName() + "[" + this.getSourceFields().print() + "->" + this.getSinkFields().print() + "]";
    }

    public int hashCode() {
        int result2 = this.sinkFields != null ? this.sinkFields.hashCode() : 0;
        result2 = 31 * result2 + (this.sourceFields != null ? this.sourceFields.hashCode() : 0);
        result2 = 31 * result2 + this.numSinkParts;
        return result2;
    }
}

