/*
 * Decompiled with CFR 0.152.
 */
package cascading.provider;

import cascading.property.PropertyUtil;
import cascading.provider.CascadingService;
import cascading.provider.ProviderLoader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ServiceLoader
extends ProviderLoader<CascadingService> {
    private static ServiceLoader serviceLoader;
    private Map<String, CascadingService> singletons = new HashMap<String, CascadingService>();

    public static synchronized ServiceLoader getInstance(URL libraryURL, String[] exclusions) {
        if (serviceLoader == null) {
            serviceLoader = new ServiceLoader(libraryURL, exclusions);
        }
        return serviceLoader;
    }

    public static synchronized void releaseSingletonsAndDestroy() {
        if (serviceLoader != null) {
            serviceLoader.releaseSingletonServices();
        }
        serviceLoader = null;
    }

    ServiceLoader(URL libraryURL, String[] exclusions) {
        super(exclusions, libraryURL);
    }

    public synchronized CascadingService loadSingletonServiceFrom(Properties defaultProperties, Map<Object, Object> properties, String property) {
        String className = PropertyUtil.getStringProperty(defaultProperties, properties, property);
        if (!this.singletons.containsKey(className)) {
            this.singletons.put(className, this.loadServiceFrom(defaultProperties, properties, property));
        }
        return this.singletons.get(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<CascadingService> releaseSingletonServices() {
        try {
            Collection<CascadingService> collection2 = Collections.unmodifiableCollection(this.singletons.values());
            return collection2;
        }
        finally {
            this.singletons.clear();
        }
    }

    public CascadingService loadServiceFrom(Properties defaultProperties, Map<Object, Object> properties, String property) {
        String className = PropertyUtil.getStringProperty(defaultProperties, properties, property);
        CascadingService service = (CascadingService)this.createProvider(className);
        if (service != null) {
            service.setProperties(properties);
        }
        return service;
    }
}

