/*
 * Decompiled with CFR 0.152.
 */
package cascading.provider;

import cascading.provider.ChildFirstURLClassLoader;
import cascading.provider.ServiceLoader;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderLoader<Provider> {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceLoader.class);
    URL libraryURL;
    String[] exclusions;
    ClassLoader classLoader;

    public ProviderLoader() {
    }

    public ProviderLoader(String[] exclusions, URL libraryURL) {
        this.exclusions = exclusions;
        this.libraryURL = libraryURL;
    }

    public Provider createProvider(String className) {
        if (className == null || className.isEmpty()) {
            return null;
        }
        if (className.startsWith("@") && className.endsWith("@")) {
            LOG.warn("invalid classname: {}", (Object)className);
            return null;
        }
        try {
            Class<?> type = this.getClassLoader().loadClass(className);
            return (Provider)type.newInstance();
        }
        catch (ClassNotFoundException exception) {
            LOG.error("unable to find service class: {}, with exception: {}", (Object)className, (Object)exception);
        }
        catch (IllegalAccessException exception) {
            LOG.error("unable to instantiate service class: {}, with exception: {}", (Object)className, (Object)exception);
        }
        catch (InstantiationException exception) {
            LOG.error("unable to instantiate service class: {}, with exception: {}", (Object)className, (Object)exception);
        }
        return null;
    }

    private synchronized ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.libraryURL == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        } else {
            LOG.info("loading services from library: {}", (Object)this.libraryURL);
            this.classLoader = new ChildFirstURLClassLoader(this.exclusions, this.libraryURL);
        }
        return this.classLoader;
    }
}

