/*
 * Decompiled with CFR 0.152.
 */
package cascading.provider;

import cascading.util.Util;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChildFirstURLClassLoader
extends ClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ChildFirstURLClassLoader.class);
    private final String[] exclusions;
    private ChildURLClassLoader childClassLoader;

    public ChildFirstURLClassLoader(String[] exclusions, URL ... urls) {
        super(Thread.currentThread().getContextClassLoader());
        this.exclusions = Util.removeNulls(exclusions);
        this.childClassLoader = new ChildURLClassLoader(urls, this.getParent());
        if (LOG.isDebugEnabled()) {
            LOG.debug("child first classloader exclusions: {}", (Object)Arrays.toString(exclusions));
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name2, boolean resolve) throws ClassNotFoundException {
        for (String exclusion : this.exclusions) {
            if (!name2.startsWith(exclusion)) continue;
            LOG.debug("loading exclusion: {}, from parent: {}", (Object)exclusion, (Object)name2);
            return super.loadClass(name2, resolve);
        }
        try {
            LOG.debug("loading from child: {}", (Object)name2);
            return this.childClassLoader.loadClass(name2);
        }
        catch (ClassNotFoundException exception) {
            return super.loadClass(name2, resolve);
        }
    }

    private class ChildURLClassLoader
    extends URLClassLoader {
        private ClassLoader parentClassLoader;

        public ChildURLClassLoader(URL[] urls, ClassLoader parentClassLoader) {
            super(urls, (ClassLoader)null);
            this.parentClassLoader = parentClassLoader;
        }

        @Override
        public Class<?> findClass(String name2) throws ClassNotFoundException {
            for (String exclusion : ChildFirstURLClassLoader.this.exclusions) {
                if (!name2.startsWith(exclusion)) continue;
                return this.parentClassLoader.loadClass(name2);
            }
            try {
                return super.findClass(name2);
            }
            catch (ClassNotFoundException exception) {
                return this.parentClassLoader.loadClass(name2);
            }
        }
    }
}

