/*
 * Decompiled with CFR 0.152.
 */
package cascading.property;

import cascading.flow.FlowElement;
import cascading.property.ConfigDef;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public class PropertyUtil {
    public static String getProperty(Map<Object, Object> properties, String property) {
        return PropertyUtil.getProperty(properties, property, (String)null);
    }

    public static String getStringProperty(Properties defaultProperties, Map<Object, Object> properties, String property) {
        if (defaultProperties == null) {
            return PropertyUtil.getProperty(properties, property);
        }
        return PropertyUtil.getProperty(properties, property, defaultProperties.getProperty(property));
    }

    public static <A> A getProperty(Map<Object, Object> properties, String key, A defaultValue2) {
        if (properties == null) {
            return defaultValue2;
        }
        Object value2 = properties instanceof Properties ? ((Properties)properties).getProperty(key) : properties.get(key);
        return (A)(value2 == null ? defaultValue2 : value2);
    }

    public static String getProperty(Map<Object, Object> properties, FlowElement flowElement, String property) {
        if (flowElement.hasConfigDef()) {
            return PropertyUtil.getProperty(properties, flowElement.getConfigDef(), property);
        }
        return PropertyUtil.getProperty(properties, property);
    }

    public static String getProperty(final Map<Object, Object> properties, ConfigDef configDef, String property) {
        return configDef.apply(property, new ConfigDef.Getter(){

            @Override
            public String update(String key, String value2) {
                return value2;
            }

            @Override
            public String get(String key) {
                return PropertyUtil.getProperty(properties, key);
            }
        });
    }

    public static void setProperty(Map<Object, Object> properties, String key, String value2) {
        if (properties == null || value2 == null || value2.isEmpty()) {
            return;
        }
        if (properties instanceof Properties) {
            ((Properties)properties).setProperty(key, value2);
        } else {
            properties.put(key, value2);
        }
    }

    public static Properties createProperties(Iterable<Map.Entry<String, String>> defaultProperties) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> property : defaultProperties) {
            properties.setProperty(property.getKey(), property.getValue());
        }
        return properties;
    }

    public static Properties createProperties(Map<Object, Object> properties, Properties defaultProperties) {
        Properties results2;
        Properties properties2 = results2 = defaultProperties == null ? new Properties() : new Properties(defaultProperties);
        if (properties == null) {
            return results2;
        }
        HashSet<Object> keys2 = new HashSet<Object>(properties.keySet());
        if (properties instanceof Properties) {
            keys2.addAll(((Properties)properties).stringPropertyNames());
        }
        for (Object e : keys2) {
            Object value2 = properties.get(e);
            if (value2 == null && properties instanceof Properties && e instanceof String) {
                value2 = ((Properties)properties).getProperty((String)e);
            }
            if (value2 == null || value2 instanceof Class) continue;
            results2.setProperty(e.toString(), value2.toString());
        }
        return results2;
    }

    public static Map<Object, Object> asFlatMap(Map<Object, Object> properties) {
        if (!(properties instanceof Properties)) {
            return properties;
        }
        HashMap<Object, Object> map2 = new HashMap<Object, Object>();
        Properties props = (Properties)properties;
        for (String property : props.stringPropertyNames()) {
            map2.put(property, props.getProperty(property));
        }
        return map2;
    }
}

