/*
 * Decompiled with CFR 0.152.
 */
package cascading.property;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ConfigDef
implements Serializable {
    protected Map<Mode, Map<String, String>> config;

    public ConfigDef setProperty(String key, String value2) {
        return this.setProperty(Mode.REPLACE, key, value2);
    }

    public ConfigDef setProperty(Mode mode2, String key, String value2) {
        this.getMode(mode2).put(key, value2);
        return this;
    }

    protected Map<String, String> getMode(Mode mode2) {
        if (this.config == null) {
            this.config = new HashMap<Mode, Map<String, String>>();
        }
        if (!this.config.containsKey((Object)mode2)) {
            this.config.put(mode2, new HashMap());
        }
        return this.config.get((Object)mode2);
    }

    protected Map<String, String> getModeSafe(Mode mode2) {
        if (this.config == null) {
            return Collections.EMPTY_MAP;
        }
        if (!this.config.containsKey((Object)mode2)) {
            return Collections.EMPTY_MAP;
        }
        return this.config.get((Object)mode2);
    }

    public boolean isEmpty() {
        return this.config == null || this.config.isEmpty();
    }

    public String apply(String key, Getter getter2) {
        String defaultValue2 = this.getModeSafe(Mode.DEFAULT).get(key);
        String replaceValue = this.getModeSafe(Mode.REPLACE).get(key);
        String updateValue = this.getModeSafe(Mode.UPDATE).get(key);
        String currentValue = getter2.get(key);
        if (currentValue == null && replaceValue == null && updateValue == null) {
            return defaultValue2;
        }
        if (replaceValue != null) {
            return replaceValue;
        }
        if (updateValue == null) {
            return currentValue;
        }
        if (currentValue == null) {
            return updateValue;
        }
        return getter2.update(key, updateValue);
    }

    public void apply(Mode mode2, Setter setter2) {
        if (!this.config.containsKey((Object)mode2)) {
            return;
        }
        for (String key : this.config.get((Object)mode2).keySet()) {
            switch (mode2) {
                case DEFAULT: {
                    if (setter2.get(key) != null) break;
                    setter2.set(key, this.config.get((Object)mode2).get(key));
                    break;
                }
                case REPLACE: {
                    setter2.set(key, this.config.get((Object)mode2).get(key));
                    break;
                }
                case UPDATE: {
                    setter2.update(key, this.config.get((Object)mode2).get(key));
                }
            }
        }
    }

    public Collection<String> getAllKeys() {
        HashSet<String> keys2 = new HashSet<String>();
        for (Map<String, String> map2 : this.config.values()) {
            keys2.addAll(map2.keySet());
        }
        return Collections.unmodifiableSet(keys2);
    }

    public static interface Getter {
        public String update(String var1, String var2);

        public String get(String var1);
    }

    public static interface Setter {
        public String set(String var1, String var2);

        public String update(String var1, String var2);

        public String get(String var1);
    }

    public static enum Mode {
        DEFAULT,
        REPLACE,
        UPDATE;

    }
}

