/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe.assembly;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Filter;
import cascading.operation.FilterCall;
import cascading.operation.OperationCall;
import cascading.operation.buffer.FirstNBuffer;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.pipe.SubAssembly;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.Tuples;
import cascading.tuple.util.TupleHasher;
import java.beans.ConstructorProperties;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Unique
extends SubAssembly {
    @ConstructorProperties(value={"pipe", "uniqueFields"})
    public Unique(Pipe pipe, Fields uniqueFields) {
        this(null, pipe, uniqueFields);
    }

    @ConstructorProperties(value={"pipe", "uniqueFields", "include"})
    public Unique(Pipe pipe, Fields uniqueFields, Include include) {
        this(null, pipe, uniqueFields, include);
    }

    @ConstructorProperties(value={"pipe", "uniqueFields", "threshold"})
    public Unique(Pipe pipe, Fields uniqueFields, int threshold) {
        this(null, pipe, uniqueFields, threshold);
    }

    @ConstructorProperties(value={"pipe", "uniqueFields", "include", "threshold"})
    public Unique(Pipe pipe, Fields uniqueFields, Include include, int threshold) {
        this(null, pipe, uniqueFields, include, threshold);
    }

    @ConstructorProperties(value={"name", "pipe", "uniqueFields"})
    public Unique(String name2, Pipe pipe, Fields uniqueFields) {
        this(name2, pipe, uniqueFields, 10000);
    }

    @ConstructorProperties(value={"name", "pipe", "uniqueFields", "include"})
    public Unique(String name2, Pipe pipe, Fields uniqueFields, Include include) {
        this(name2, pipe, uniqueFields, include, 10000);
    }

    @ConstructorProperties(value={"name", "pipe", "uniqueFields", "threshold"})
    public Unique(String name2, Pipe pipe, Fields uniqueFields, int threshold) {
        this(name2, Pipe.pipes(pipe), uniqueFields, threshold);
    }

    @ConstructorProperties(value={"name", "pipe", "uniqueFields", "include", "threshold"})
    public Unique(String name2, Pipe pipe, Fields uniqueFields, Include include, int threshold) {
        this(name2, Pipe.pipes(pipe), uniqueFields, include, threshold);
    }

    @ConstructorProperties(value={"pipes", "uniqueFields"})
    public Unique(Pipe[] pipes, Fields uniqueFields) {
        this(null, pipes, uniqueFields, 10000);
    }

    @ConstructorProperties(value={"pipes", "uniqueFields", "include"})
    public Unique(Pipe[] pipes, Fields uniqueFields, Include include) {
        this(null, pipes, uniqueFields, include, 10000);
    }

    @ConstructorProperties(value={"pipes", "uniqueFields", "threshold"})
    public Unique(Pipe[] pipes, Fields uniqueFields, int threshold) {
        this(null, pipes, uniqueFields, threshold);
    }

    @ConstructorProperties(value={"pipes", "uniqueFields", "include", "threshold"})
    public Unique(Pipe[] pipes, Fields uniqueFields, Include include, int threshold) {
        this(null, pipes, uniqueFields, include, threshold);
    }

    @ConstructorProperties(value={"name", "pipes", "uniqueFields"})
    public Unique(String name2, Pipe[] pipes, Fields uniqueFields) {
        this(name2, pipes, uniqueFields, 10000);
    }

    @ConstructorProperties(value={"name", "pipes", "uniqueFields", "include"})
    public Unique(String name2, Pipe[] pipes, Fields uniqueFields, Include include) {
        this(name2, pipes, uniqueFields, include, 10000);
    }

    @ConstructorProperties(value={"name", "pipes", "uniqueFields", "threshold"})
    public Unique(String name2, Pipe[] pipes, Fields uniqueFields, int threshold) {
        this(name2, pipes, uniqueFields, null, threshold);
    }

    @ConstructorProperties(value={"name", "pipes", "uniqueFields", "include", "threshold"})
    public Unique(String name2, Pipe[] pipes, Fields uniqueFields, Include include, int threshold) {
        super(pipes);
        if (uniqueFields == null) {
            throw new IllegalArgumentException("uniqueFields may not be null");
        }
        Pipe[] filters = new Pipe[pipes.length];
        TupleHasher tupleHasher = null;
        Comparator[] comparators = uniqueFields.getComparators();
        if (!TupleHasher.isNull(comparators)) {
            tupleHasher = new TupleHasher(null, comparators);
        }
        FilterPartialDuplicates partialDuplicates = new FilterPartialDuplicates(include, threshold, tupleHasher);
        for (int i = 0; i < filters.length; ++i) {
            filters[i] = new Each(pipes[i], uniqueFields, (Filter)partialDuplicates);
        }
        Pipe pipe = new GroupBy(name2, filters, uniqueFields);
        pipe = new Every(pipe, Fields.ALL, new FirstNBuffer(), Fields.RESULTS);
        this.setTails(pipe);
    }

    public static class FilterPartialDuplicates
    extends BaseOperation<LinkedHashMap<Tuple, Object>>
    implements Filter<LinkedHashMap<Tuple, Object>> {
        private int threshold = 10000;
        private Include include = Include.ALL;
        private TupleHasher tupleHasher;

        public FilterPartialDuplicates() {
        }

        @ConstructorProperties(value={"threshold"})
        public FilterPartialDuplicates(int threshold) {
            this.threshold = threshold;
        }

        @ConstructorProperties(value={"include", "threshold"})
        public FilterPartialDuplicates(Include include, int threshold) {
            this(include, threshold, null);
        }

        @ConstructorProperties(value={"include", "threshold", "tupleHasher"})
        public FilterPartialDuplicates(Include include, int threshold, TupleHasher tupleHasher) {
            this.threshold = threshold;
            this.include = include == null ? this.include : include;
            this.tupleHasher = tupleHasher;
        }

        @Override
        public void prepare(final FlowProcess flowProcess, OperationCall<LinkedHashMap<Tuple, Object>> operationCall) {
            operationCall.setContext(new LinkedHashMap<Tuple, Object>(this.threshold, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry eldest) {
                    boolean doFlush;
                    boolean bl = doFlush = this.size() > FilterPartialDuplicates.this.threshold;
                    if (doFlush) {
                        flowProcess.increment(Cache.Num_Keys_Flushed, 1L);
                    }
                    return doFlush;
                }
            });
        }

        @Override
        public boolean isRemove(FlowProcess flowProcess, FilterCall<LinkedHashMap<Tuple, Object>> filterCall) {
            Tuple args2 = TupleHasher.wrapTuple(this.tupleHasher, filterCall.getArguments().getTuple());
            switch (this.include) {
                case ALL: {
                    break;
                }
                case NO_NULLS: {
                    if (Tuples.frequency(args2, null) != args2.size()) break;
                    return true;
                }
            }
            if (((LinkedHashMap)filterCall.getContext()).containsKey(args2)) {
                flowProcess.increment(Cache.Num_Keys_Hit, 1L);
                return true;
            }
            ((LinkedHashMap)filterCall.getContext()).put(TupleHasher.wrapTuple(this.tupleHasher, filterCall.getArguments().getTupleCopy()), null);
            flowProcess.increment(Cache.Num_Keys_Missed, 1L);
            return false;
        }

        @Override
        public void cleanup(FlowProcess flowProcess, OperationCall<LinkedHashMap<Tuple, Object>> operationCall) {
            operationCall.setContext(null);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof FilterPartialDuplicates)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            FilterPartialDuplicates that = (FilterPartialDuplicates)object;
            return this.threshold == that.threshold;
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + this.threshold;
            return result2;
        }
    }

    public static enum Cache {
        Num_Keys_Flushed,
        Num_Keys_Hit,
        Num_Keys_Missed;

    }

    public static enum Include {
        ALL,
        NO_NULLS;

    }
}

