/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe.assembly;

import cascading.flow.FlowProcess;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyConfigured;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.operation.Aggregator;
import cascading.operation.BaseOperation;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.pipe.SubAssembly;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.util.TupleHasher;
import cascading.tuple.util.TupleViews;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateBy
extends SubAssembly {
    private static final Logger LOG = LoggerFactory.getLogger(AggregateBy.class);
    public static final int USE_DEFAULT_THRESHOLD = 0;
    public static final int DEFAULT_THRESHOLD = 10000;
    public static final String AGGREGATE_BY_THRESHOLD = "cascading.aggregateby.threshold";
    private String name;
    private int threshold;
    private Fields groupingFields;
    private Fields[] argumentFields;
    private Functor[] functors;
    private Aggregator[] aggregators;
    private transient GroupBy groupBy;

    protected AggregateBy(String name2, int threshold) {
        this.name = name2;
        this.threshold = threshold;
    }

    protected AggregateBy(Fields argumentFields, Functor functor, Aggregator aggregator) {
        this.argumentFields = Fields.fields(argumentFields);
        this.functors = new Functor[]{functor};
        this.aggregators = new Aggregator[]{aggregator};
    }

    @ConstructorProperties(value={"pipe", "groupingFields", "assemblies"})
    public AggregateBy(Pipe pipe, Fields groupingFields, AggregateBy ... assemblies) {
        this(null, Pipe.pipes(pipe), groupingFields, 0, assemblies);
    }

    @ConstructorProperties(value={"pipe", "groupingFields", "threshold", "assemblies"})
    public AggregateBy(Pipe pipe, Fields groupingFields, int threshold, AggregateBy ... assemblies) {
        this(null, Pipe.pipes(pipe), groupingFields, threshold, assemblies);
    }

    @ConstructorProperties(value={"name", "pipe", "groupingFields", "threshold", "assemblies"})
    public AggregateBy(String name2, Pipe pipe, Fields groupingFields, int threshold, AggregateBy ... assemblies) {
        this(name2, Pipe.pipes(pipe), groupingFields, threshold, assemblies);
    }

    @ConstructorProperties(value={"name", "pipes", "groupingFields", "assemblies"})
    public AggregateBy(String name2, Pipe[] pipes, Fields groupingFields, AggregateBy ... assemblies) {
        this(name2, pipes, groupingFields, 0, assemblies);
    }

    @ConstructorProperties(value={"name", "pipes", "groupingFields", "threshold", "assemblies"})
    public AggregateBy(String name2, Pipe[] pipes, Fields groupingFields, int threshold, AggregateBy ... assemblies) {
        this(name2, threshold);
        ArrayList arguments = new ArrayList();
        ArrayList functors = new ArrayList();
        ArrayList aggregators = new ArrayList();
        for (int i = 0; i < assemblies.length; ++i) {
            AggregateBy assembly = assemblies[i];
            Collections.addAll(arguments, assembly.getArgumentFields());
            Collections.addAll(functors, assembly.getFunctors());
            Collections.addAll(aggregators, assembly.getAggregators());
        }
        this.initialize(groupingFields, pipes, arguments.toArray(new Fields[arguments.size()]), functors.toArray(new Functor[functors.size()]), aggregators.toArray(new Aggregator[aggregators.size()]));
    }

    protected AggregateBy(String name2, Pipe[] pipes, Fields groupingFields, Fields argumentFields, Functor functor, Aggregator aggregator, int threshold) {
        this(name2, threshold);
        this.initialize(groupingFields, pipes, argumentFields, functor, aggregator);
    }

    protected void initialize(Fields groupingFields, Pipe[] pipes, Fields argumentFields, Functor functor, Aggregator aggregator) {
        this.initialize(groupingFields, pipes, Fields.fields(argumentFields), new Functor[]{functor}, new Aggregator[]{aggregator});
    }

    protected void initialize(Fields groupingFields, Pipe[] pipes, Fields[] argumentFields, Functor[] functors, Aggregator[] aggregators) {
        this.setPrevious(pipes);
        this.groupingFields = groupingFields;
        this.argumentFields = argumentFields;
        this.functors = functors;
        this.aggregators = aggregators;
        this.verify();
        Fields sortFields = Fields.copyComparators(Fields.merge(this.argumentFields), this.argumentFields);
        Fields argumentSelector = Fields.merge(this.groupingFields, sortFields);
        if (argumentSelector.equals(Fields.NONE)) {
            argumentSelector = Fields.ALL;
        }
        Pipe[] functions = new Pipe[pipes.length];
        CompositeFunction function = new CompositeFunction(this.groupingFields, this.argumentFields, this.functors, this.threshold);
        for (int i = 0; i < functions.length; ++i) {
            functions[i] = new Each(pipes[i], argumentSelector, (Function)function, Fields.RESULTS);
        }
        Pipe pipe = this.groupBy = new GroupBy(this.name, functions, this.groupingFields, sortFields.hasComparators() ? sortFields : null);
        for (int i = 0; i < aggregators.length; ++i) {
            pipe = new Every(pipe, this.functors[i].getDeclaredFields(), this.aggregators[i], Fields.ALL);
        }
        this.setTails(pipe);
    }

    protected void verify() {
    }

    public Fields getGroupingFields() {
        return this.groupingFields;
    }

    public Fields[] getFieldDeclarations() {
        Fields[] fields2 = new Fields[this.aggregators.length];
        for (int i = 0; i < this.aggregators.length; ++i) {
            fields2[i] = this.aggregators[i].getFieldDeclaration();
        }
        return fields2;
    }

    protected Fields[] getArgumentFields() {
        return this.argumentFields;
    }

    protected Functor[] getFunctors() {
        return this.functors;
    }

    protected Aggregator[] getAggregators() {
        return this.aggregators;
    }

    public GroupBy getGroupBy() {
        return this.groupBy;
    }

    @Property(name="threshold", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="Threshold of the aggregation.")
    @PropertyConfigured(value="cascading.aggregateby.threshold", defaultValue="10000")
    public int getThreshold() {
        return this.threshold;
    }

    public static class CompositeFunction
    extends BaseOperation<Context>
    implements Function<Context> {
        public static final int DEFAULT_THRESHOLD = 10000;
        private int threshold = 0;
        private final Fields groupingFields;
        private final Fields[] argumentFields;
        private final Fields[] functorFields;
        private final Functor[] functors;
        private final TupleHasher tupleHasher;

        public CompositeFunction(Fields groupingFields, Fields argumentFields, Functor functor, int threshold) {
            this(groupingFields, Fields.fields(argumentFields), new Functor[]{functor}, threshold);
        }

        public CompositeFunction(Fields groupingFields, Fields[] argumentFields, Functor[] functors, int threshold) {
            super(CompositeFunction.getFields(groupingFields, functors));
            this.groupingFields = groupingFields;
            this.argumentFields = argumentFields;
            this.functors = functors;
            this.threshold = threshold;
            this.functorFields = new Fields[functors.length];
            for (int i = 0; i < functors.length; ++i) {
                this.functorFields[i] = functors[i].getDeclaredFields();
            }
            Comparator[] hashers = TupleHasher.merge(this.functorFields);
            this.tupleHasher = !TupleHasher.isNull(hashers) ? new TupleHasher(null, hashers) : null;
        }

        private static Fields getFields(Fields groupingFields, Functor[] functors) {
            Fields fields2 = groupingFields;
            for (Functor functor : functors) {
                fields2 = fields2.append(functor.getDeclaredFields());
            }
            return fields2;
        }

        @Override
        public void prepare(final FlowProcess flowProcess, final OperationCall<Context> operationCall) {
            if (this.threshold == 0) {
                Integer value2 = flowProcess.getIntegerProperty(AggregateBy.AGGREGATE_BY_THRESHOLD);
                this.threshold = value2 != null && value2 > 0 ? value2 : 10000;
            }
            LOG.info("using threshold value: {}", (Object)this.threshold);
            Fields[] fields2 = new Fields[this.functors.length + 1];
            fields2[0] = this.groupingFields;
            for (int i = 0; i < this.functors.length; ++i) {
                fields2[i + 1] = this.functors[i].getDeclaredFields();
            }
            final Context context = new Context();
            context.arguments = new TupleEntry[this.functors.length];
            for (int i = 0; i < context.arguments.length; ++i) {
                Fields resolvedArgumentFields = operationCall.getArgumentFields();
                int[] pos = this.argumentFields[i].isAll() ? resolvedArgumentFields.getPos() : resolvedArgumentFields.getPos(this.argumentFields[i]);
                Tuple narrow = TupleViews.createNarrow(pos);
                Fields currentFields = this.argumentFields[i].isSubstitution() ? resolvedArgumentFields.select(this.argumentFields[i]) : Fields.asDeclaration(this.argumentFields[i]);
                context.arguments[i] = new TupleEntry(currentFields, narrow);
            }
            context.result = TupleViews.createComposite(fields2);
            context.lru = new LinkedHashMap<Tuple, Tuple[]>(this.threshold, 0.75f, true){
                long flushes;
                {
                    super(x0, x1, x2);
                    this.flushes = 0L;
                }

                @Override
                protected boolean removeEldestEntry(Map.Entry<Tuple, Tuple[]> eldest) {
                    boolean doRemove;
                    boolean bl = doRemove = this.size() > CompositeFunction.this.threshold;
                    if (doRemove) {
                        CompositeFunction.this.completeFunctors(flowProcess, ((FunctionCall)operationCall).getOutputCollector(), context.result, eldest);
                        flowProcess.increment(Cache.Num_Keys_Flushed, 1L);
                        flowProcess.increment(Flush.Num_Keys_Flushed, 1L);
                        if (this.flushes % (long)CompositeFunction.this.threshold == 0L) {
                            Runtime runtime = Runtime.getRuntime();
                            long freeMem = runtime.freeMemory() / 1024L / 1024L;
                            long maxMem = runtime.maxMemory() / 1024L / 1024L;
                            long totalMem = runtime.totalMemory() / 1024L / 1024L;
                            LOG.info("flushed keys num times: {}, with threshold: {}", (Object)(this.flushes + 1L), (Object)CompositeFunction.this.threshold);
                            LOG.info("mem on flush (mb), free: " + freeMem + ", total: " + totalMem + ", max: " + maxMem);
                            float percent = (float)totalMem / (float)maxMem;
                            if (percent < 0.8f) {
                                LOG.info("total mem is {}% of max mem, to better utilize unused memory consider increasing current LRU threshold with system property \"{}\"", (Object)((int)(percent * 100.0f)), (Object)AggregateBy.AGGREGATE_BY_THRESHOLD);
                            }
                        }
                        ++this.flushes;
                    }
                    return doRemove;
                }
            };
            operationCall.setContext(context);
        }

        @Override
        public void operate(FlowProcess flowProcess, FunctionCall<Context> functionCall) {
            TupleEntry arguments = functionCall.getArguments();
            Tuple key = TupleHasher.wrapTuple(this.tupleHasher, arguments.selectTupleCopy(this.groupingFields));
            Context context = (Context)functionCall.getContext();
            Tuple[] functorContext = context.lru.get(key);
            if (functorContext == null) {
                functorContext = new Tuple[this.functors.length];
                context.lru.put(key, functorContext);
                flowProcess.increment(Cache.Num_Keys_Missed, 1L);
            } else {
                flowProcess.increment(Cache.Num_Keys_Hit, 1L);
            }
            for (int i = 0; i < this.functors.length; ++i) {
                TupleViews.reset(context.arguments[i].getTuple(), arguments.getTuple());
                functorContext[i] = this.functors[i].aggregate(flowProcess, context.arguments[i], functorContext[i]);
            }
        }

        @Override
        public void flush(FlowProcess flowProcess, OperationCall<Context> operationCall) {
            TupleEntryCollector collector = ((FunctionCall)operationCall).getOutputCollector();
            Tuple result2 = operationCall.getContext().result;
            LinkedHashMap<Tuple, Tuple[]> context = operationCall.getContext().lru;
            for (Map.Entry<Tuple, Tuple[]> entry2 : context.entrySet()) {
                this.completeFunctors(flowProcess, collector, result2, entry2);
            }
            operationCall.setContext(null);
        }

        private void completeFunctors(FlowProcess flowProcess, TupleEntryCollector outputCollector, Tuple result2, Map.Entry<Tuple, Tuple[]> entry2) {
            Tuple[] results2 = new Tuple[this.functors.length + 1];
            results2[0] = entry2.getKey();
            Tuple[] values2 = entry2.getValue();
            for (int i = 0; i < this.functors.length; ++i) {
                results2[i + 1] = this.functors[i].complete(flowProcess, values2[i]);
            }
            TupleViews.reset(result2, results2);
            outputCollector.add(result2);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CompositeFunction)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            CompositeFunction that = (CompositeFunction)object;
            if (!Arrays.equals(this.argumentFields, that.argumentFields)) {
                return false;
            }
            if (!Arrays.equals(this.functorFields, that.functorFields)) {
                return false;
            }
            if (!Arrays.equals(this.functors, that.functors)) {
                return false;
            }
            return !(this.groupingFields != null ? !this.groupingFields.equals(that.groupingFields) : that.groupingFields != null);
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + (this.groupingFields != null ? this.groupingFields.hashCode() : 0);
            result2 = 31 * result2 + (this.argumentFields != null ? Arrays.hashCode(this.argumentFields) : 0);
            result2 = 31 * result2 + (this.functorFields != null ? Arrays.hashCode(this.functorFields) : 0);
            result2 = 31 * result2 + (this.functors != null ? Arrays.hashCode(this.functors) : 0);
            return result2;
        }

        public static class Context {
            LinkedHashMap<Tuple, Tuple[]> lru;
            TupleEntry[] arguments;
            Tuple result;
        }
    }

    public static interface Functor
    extends Serializable {
        public Fields getDeclaredFields();

        public Tuple aggregate(FlowProcess var1, TupleEntry var2, Tuple var3);

        public Tuple complete(FlowProcess var1, Tuple var2);
    }

    @Deprecated
    public static enum Flush {
        Num_Keys_Flushed;

    }

    public static enum Cache {
        Num_Keys_Flushed,
        Num_Keys_Hit,
        Num_Keys_Missed;

    }
}

