/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe;

import cascading.pipe.Pipe;
import cascading.util.TraceUtil;
import cascading.util.Util;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SubAssembly
extends Pipe {
    private static final Logger LOG = LoggerFactory.getLogger(SubAssembly.class);
    private Pipe[] previous;
    private Pipe[] tails;
    private transient String[] names;

    public static Pipe[] unwind(Pipe ... tails2) {
        HashSet<Pipe> previous = new HashSet<Pipe>();
        for (Pipe pipe : tails2) {
            if (pipe instanceof SubAssembly) {
                Collections.addAll(previous, SubAssembly.unwind(pipe.getPrevious()));
                continue;
            }
            previous.add(pipe);
        }
        return previous.toArray(new Pipe[previous.size()]);
    }

    protected SubAssembly() {
    }

    protected SubAssembly(Pipe ... previous) {
        this.setPrevious(previous);
    }

    protected SubAssembly(String name2, Pipe[] previous) {
        super(name2);
        this.setPrevious(previous);
    }

    protected void setPrevious(Pipe ... previous) {
        this.previous = previous;
    }

    protected void setTails(Pipe ... tails2) {
        this.tails = tails2;
        if (this.previous == null) {
            LOG.warn("previous pipes not set via setPrevious or constructor on: {}", (Object)this);
            return;
        }
        HashSet<Pipe> stopSet = new HashSet<Pipe>();
        Collections.addAll(stopSet, this.previous);
        this.setParent(stopSet, tails2);
    }

    private void setParent(Set<Pipe> stopSet, Pipe[] tails2) {
        if (tails2 == null) {
            return;
        }
        for (Pipe tail : tails2) {
            if (stopSet.contains(tail)) continue;
            tail.setParent(this);
            Pipe[] current = tail instanceof SubAssembly ? ((SubAssembly)tail).previous : tail.getPrevious();
            if (current == null && tail instanceof SubAssembly) {
                LOG.warn("previous pipes not set via setPrevious or constructor on: {}", (Object)tail);
            }
            this.setParent(stopSet, current);
        }
    }

    public Pipe[] getTails() {
        return this.getPrevious();
    }

    public String[] getTailNames() {
        if (this.tails == null) {
            throw new IllegalStateException(TraceUtil.formatRawTrace(this, "setTails must be called in the constructor"));
        }
        if (this.names != null) {
            return this.names;
        }
        this.names = new String[this.tails.length];
        for (int i = 0; i < this.tails.length; ++i) {
            this.names[i] = this.tails[i].getName();
        }
        return this.names;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = Util.join(this.getTailNames(), "+");
        }
        return this.name;
    }

    @Override
    public Pipe[] getPrevious() {
        if (this.tails == null) {
            throw new IllegalStateException(TraceUtil.formatRawTrace(this, "setTails must be called after the sub-assembly is assembled"));
        }
        return Arrays.copyOf(this.tails, this.tails.length);
    }
}

