/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe;

import cascading.flow.FlowElement;
import cascading.flow.planner.DeclaresResults;
import cascading.flow.planner.Scope;
import cascading.pipe.CoGroup;
import cascading.pipe.GroupBy;
import cascading.pipe.Merge;
import cascading.pipe.OperatorException;
import cascading.pipe.Pipe;
import cascading.pipe.joiner.BufferJoin;
import cascading.pipe.joiner.InnerJoin;
import cascading.pipe.joiner.Joiner;
import cascading.tuple.Fields;
import cascading.tuple.FieldsResolverException;
import cascading.tuple.TupleException;
import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.CoercibleType;
import cascading.util.Util;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Splice
extends Pipe {
    private Kind kind;
    private String spliceName;
    private final List<Pipe> pipes = new ArrayList<Pipe>();
    protected final Map<String, Fields> keyFieldsMap = new LinkedHashMap<String, Fields>();
    protected Map<String, Fields> sortFieldsMap = new LinkedHashMap<String, Fields>();
    private boolean reverseOrder = false;
    protected Fields declaredFields;
    protected Fields resultGroupFields;
    private int numSelfJoins = 0;
    private Joiner joiner;
    private transient Map<String, Integer> pipePos;

    protected Splice(Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields, Fields declaredFields) {
        this(lhs, lhsGroupFields, rhs, rhsGroupFields, declaredFields, null, null);
    }

    protected Splice(Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields, Fields declaredFields, Fields resultGroupFields) {
        this(lhs, lhsGroupFields, rhs, rhsGroupFields, declaredFields, resultGroupFields, null);
    }

    protected Splice(Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields, Fields declaredFields, Joiner joiner) {
        this(Pipe.pipes(lhs, rhs), Fields.fields(lhsGroupFields, rhsGroupFields), declaredFields, joiner);
    }

    protected Splice(Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields, Fields declaredFields, Fields resultGroupFields, Joiner joiner) {
        this(Pipe.pipes(lhs, rhs), Fields.fields(lhsGroupFields, rhsGroupFields), declaredFields, resultGroupFields, joiner);
    }

    protected Splice(Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields, Joiner joiner) {
        this(lhs, lhsGroupFields, rhs, rhsGroupFields, null, joiner);
    }

    protected Splice(Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields) {
        this(Pipe.pipes(lhs, rhs), Fields.fields(lhsGroupFields, rhsGroupFields));
    }

    protected Splice(Pipe ... pipes) {
        this(pipes, (Fields[])null);
    }

    protected Splice(Pipe[] pipes, Fields[] groupFields) {
        this(null, pipes, groupFields, null, null);
    }

    protected Splice(String spliceName, Pipe[] pipes, Fields[] groupFields) {
        this(spliceName, pipes, groupFields, null, null);
    }

    protected Splice(String spliceName, Pipe[] pipes, Fields[] groupFields, Fields declaredFields) {
        this(spliceName, pipes, groupFields, declaredFields, null);
    }

    protected Splice(String spliceName, Pipe[] pipes, Fields[] groupFields, Fields declaredFields, Fields resultGroupFields) {
        this(spliceName, pipes, groupFields, declaredFields, resultGroupFields, null);
    }

    protected Splice(Pipe[] pipes, Fields[] groupFields, Fields declaredFields, Joiner joiner) {
        this(null, pipes, groupFields, declaredFields, null, joiner);
    }

    protected Splice(Pipe[] pipes, Fields[] groupFields, Fields declaredFields, Fields resultGroupFields, Joiner joiner) {
        this(null, pipes, groupFields, declaredFields, resultGroupFields, joiner);
    }

    protected Splice(String spliceName, Pipe[] pipes, Fields[] groupFields, Fields declaredFields, Fields resultGroupFields, Joiner joiner) {
        this.setKind();
        this.spliceName = spliceName;
        int uniques = new HashSet<Pipe>(Arrays.asList(Pipe.resolvePreviousAll(pipes))).size();
        if (pipes.length > 1 && uniques == 1) {
            if (new HashSet<Fields>(Arrays.asList(groupFields)).size() != 1) {
                throw new IllegalArgumentException("all groupFields must be identical");
            }
            this.addPipe(pipes[0]);
            this.numSelfJoins = pipes.length - 1;
            this.keyFieldsMap.put(pipes[0].getName(), groupFields[0]);
            if (resultGroupFields != null && groupFields[0].size() * pipes.length != resultGroupFields.size()) {
                throw new IllegalArgumentException("resultGroupFields and cogroup joined fields must be same size");
            }
        } else {
            int last2 = -1;
            for (int i = 0; i < pipes.length; ++i) {
                this.addPipe(pipes[i]);
                if (groupFields == null || groupFields.length == 0) {
                    this.addGroupFields(pipes[i], Fields.FIRST);
                    continue;
                }
                if (last2 != -1 && last2 != groupFields[i].size()) {
                    throw new IllegalArgumentException("all groupFields must be same size");
                }
                last2 = groupFields[i].size();
                this.addGroupFields(pipes[i], groupFields[i]);
            }
            if (resultGroupFields != null && last2 * pipes.length != resultGroupFields.size()) {
                throw new IllegalArgumentException("resultGroupFields and cogroup resulting joined fields must be same size");
            }
        }
        this.declaredFields = declaredFields;
        this.resultGroupFields = resultGroupFields;
        this.joiner = joiner;
        this.verifyCoGrouper();
    }

    protected Splice(String spliceName, Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields, Fields declaredFields) {
        this(lhs, lhsGroupFields, rhs, rhsGroupFields, declaredFields);
        this.spliceName = spliceName;
    }

    protected Splice(String spliceName, Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields, Fields declaredFields, Fields resultGroupFields) {
        this(lhs, lhsGroupFields, rhs, rhsGroupFields, declaredFields, resultGroupFields);
        this.spliceName = spliceName;
    }

    protected Splice(String spliceName, Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields, Fields declaredFields, Joiner joiner) {
        this(lhs, lhsGroupFields, rhs, rhsGroupFields, declaredFields, joiner);
        this.spliceName = spliceName;
    }

    protected Splice(String spliceName, Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields, Fields declaredFields, Fields resultGroupFields, Joiner joiner) {
        this(lhs, lhsGroupFields, rhs, rhsGroupFields, declaredFields, resultGroupFields, joiner);
        this.spliceName = spliceName;
    }

    protected Splice(String spliceName, Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields, Joiner joiner) {
        this(lhs, lhsGroupFields, rhs, rhsGroupFields, joiner);
        this.spliceName = spliceName;
    }

    protected Splice(String spliceName, Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields) {
        this(lhs, lhsGroupFields, rhs, rhsGroupFields);
        this.spliceName = spliceName;
    }

    protected Splice(String spliceName, Pipe ... pipes) {
        this(pipes);
        this.spliceName = spliceName;
    }

    protected Splice(Pipe pipe, Fields groupFields, int numSelfJoins, Fields declaredFields) {
        this(pipe, groupFields, numSelfJoins);
        this.declaredFields = declaredFields;
    }

    protected Splice(Pipe pipe, Fields groupFields, int numSelfJoins, Fields declaredFields, Fields resultGroupFields) {
        this(pipe, groupFields, numSelfJoins);
        this.declaredFields = declaredFields;
        this.resultGroupFields = resultGroupFields;
        if (resultGroupFields != null && groupFields.size() * numSelfJoins != resultGroupFields.size()) {
            throw new IllegalArgumentException("resultGroupFields and cogroup resulting join fields must be same size");
        }
    }

    protected Splice(Pipe pipe, Fields groupFields, int numSelfJoins, Fields declaredFields, Joiner joiner) {
        this(pipe, groupFields, numSelfJoins, declaredFields);
        this.joiner = joiner;
        this.verifyCoGrouper();
    }

    protected Splice(Pipe pipe, Fields groupFields, int numSelfJoins, Fields declaredFields, Fields resultGroupFields, Joiner joiner) {
        this(pipe, groupFields, numSelfJoins, declaredFields, resultGroupFields);
        this.joiner = joiner;
        this.verifyCoGrouper();
    }

    protected Splice(Pipe pipe, Fields groupFields, int numSelfJoins, Joiner joiner) {
        this.setKind();
        this.addPipe(pipe);
        this.keyFieldsMap.put(pipe.getName(), groupFields);
        this.numSelfJoins = numSelfJoins;
        this.joiner = joiner;
        this.verifyCoGrouper();
    }

    protected Splice(Pipe pipe, Fields groupFields, int numSelfJoins) {
        this(pipe, groupFields, numSelfJoins, (Joiner)null);
    }

    protected Splice(String spliceName, Pipe pipe, Fields groupFields, int numSelfJoins, Fields declaredFields) {
        this(pipe, groupFields, numSelfJoins, declaredFields);
        this.spliceName = spliceName;
    }

    protected Splice(String spliceName, Pipe pipe, Fields groupFields, int numSelfJoins, Fields declaredFields, Fields resultGroupFields) {
        this(pipe, groupFields, numSelfJoins, declaredFields, resultGroupFields);
        this.spliceName = spliceName;
    }

    protected Splice(String spliceName, Pipe pipe, Fields groupFields, int numSelfJoins, Fields declaredFields, Joiner joiner) {
        this(pipe, groupFields, numSelfJoins, declaredFields, joiner);
        this.spliceName = spliceName;
    }

    protected Splice(String spliceName, Pipe pipe, Fields groupFields, int numSelfJoins, Fields declaredFields, Fields resultGroupFields, Joiner joiner) {
        this(pipe, groupFields, numSelfJoins, declaredFields, resultGroupFields, joiner);
        this.spliceName = spliceName;
    }

    protected Splice(String spliceName, Pipe pipe, Fields groupFields, int numSelfJoins, Joiner joiner) {
        this(pipe, groupFields, numSelfJoins, joiner);
        this.spliceName = spliceName;
    }

    protected Splice(String spliceName, Pipe pipe, Fields groupFields, int numSelfJoins) {
        this(pipe, groupFields, numSelfJoins);
        this.spliceName = spliceName;
    }

    protected Splice(Pipe pipe) {
        this(null, pipe, Fields.ALL, null, false);
    }

    protected Splice(Pipe pipe, Fields groupFields) {
        this(null, pipe, groupFields, null, false);
    }

    protected Splice(String spliceName, Pipe pipe, Fields groupFields) {
        this(spliceName, pipe, groupFields, null, false);
    }

    protected Splice(Pipe pipe, Fields groupFields, Fields sortFields) {
        this(null, pipe, groupFields, sortFields, false);
    }

    protected Splice(String spliceName, Pipe pipe, Fields groupFields, Fields sortFields) {
        this(spliceName, pipe, groupFields, sortFields, false);
    }

    protected Splice(Pipe pipe, Fields groupFields, Fields sortFields, boolean reverseOrder) {
        this(null, pipe, groupFields, sortFields, reverseOrder);
    }

    protected Splice(String spliceName, Pipe pipe, Fields groupFields, Fields sortFields, boolean reverseOrder) {
        this(spliceName, Pipe.pipes(pipe), groupFields, sortFields, reverseOrder);
    }

    protected Splice(Pipe[] pipes, Fields groupFields) {
        this(null, pipes, groupFields, null, false);
    }

    protected Splice(String spliceName, Pipe[] pipes, Fields groupFields) {
        this(spliceName, pipes, groupFields, null, false);
    }

    protected Splice(Pipe[] pipes, Fields groupFields, Fields sortFields) {
        this(null, pipes, groupFields, sortFields, false);
    }

    protected Splice(String spliceName, Pipe[] pipe, Fields groupFields, Fields sortFields) {
        this(spliceName, pipe, groupFields, sortFields, false);
    }

    protected Splice(Pipe[] pipes, Fields groupFields, Fields sortFields, boolean reverseOrder) {
        this(null, pipes, groupFields, sortFields, reverseOrder);
    }

    protected Splice(String spliceName, Pipe[] pipes, Fields groupFields, Fields sortFields, boolean reverseOrder) {
        this.setKind();
        this.spliceName = spliceName;
        for (Pipe pipe : pipes) {
            this.addPipe(pipe);
            this.keyFieldsMap.put(pipe.getName(), groupFields);
            if (sortFields == null) continue;
            this.sortFieldsMap.put(pipe.getName(), sortFields);
        }
        this.reverseOrder = reverseOrder;
        this.joiner = new InnerJoin();
    }

    private void verifyCoGrouper() {
        if (this.isJoin() && this.joiner instanceof BufferJoin) {
            throw new IllegalArgumentException("invalid joiner, may not use BufferJoiner in a HashJoin");
        }
        if (this.joiner == null) {
            this.joiner = new InnerJoin();
            return;
        }
        if (this.joiner.numJoins() == -1) {
            return;
        }
        int joins = Math.max(this.numSelfJoins, this.keyFieldsMap.size() - 1);
        if (joins != this.joiner.numJoins()) {
            throw new IllegalArgumentException("invalid joiner, only accepts " + this.joiner.numJoins() + " joins, there are: " + joins);
        }
    }

    private void setKind() {
        this.kind = this instanceof GroupBy ? Kind.GroupBy : (this instanceof CoGroup ? Kind.CoGroup : (this instanceof Merge ? Kind.Merge : Kind.Join));
    }

    public Fields getDeclaredFields() {
        return this.declaredFields;
    }

    private void addPipe(Pipe pipe) {
        if (pipe.getName() == null) {
            throw new IllegalArgumentException("each input pipe must have a name");
        }
        this.pipes.add(pipe);
    }

    private void addGroupFields(Pipe pipe, Fields fields2) {
        if (this.keyFieldsMap.containsKey(pipe.getName())) {
            throw new IllegalArgumentException("each input pipe branch must be uniquely named");
        }
        this.keyFieldsMap.put(pipe.getName(), fields2);
    }

    @Override
    public String getName() {
        if (this.spliceName != null) {
            return this.spliceName;
        }
        StringBuffer buffer2 = new StringBuffer();
        for (Pipe pipe : this.pipes) {
            if (buffer2.length() != 0) {
                if (this.isGroupBy() || this.isMerge()) {
                    buffer2.append("+");
                } else if (this.isCoGroup() || this.isJoin()) {
                    buffer2.append("*");
                }
            }
            buffer2.append(pipe.getName());
        }
        this.spliceName = buffer2.toString();
        return this.spliceName;
    }

    @Override
    public Pipe[] getPrevious() {
        return this.pipes.toArray(new Pipe[this.pipes.size()]);
    }

    public Map<String, Fields> getKeySelectors() {
        return this.keyFieldsMap;
    }

    public Map<String, Fields> getSortingSelectors() {
        return this.sortFieldsMap;
    }

    public boolean isSorted() {
        return !this.sortFieldsMap.isEmpty();
    }

    public boolean isSortReversed() {
        return this.reverseOrder;
    }

    public synchronized Map<String, Integer> getPipePos() {
        if (this.pipePos != null) {
            return this.pipePos;
        }
        this.pipePos = new HashMap<String, Integer>();
        int pos = 0;
        for (Pipe pipe : this.pipes) {
            this.pipePos.put(pipe.getName(), pos++);
        }
        return this.pipePos;
    }

    public Joiner getJoiner() {
        return this.joiner;
    }

    public final boolean isGroupBy() {
        return this.kind == Kind.GroupBy;
    }

    public final boolean isCoGroup() {
        return this.kind == Kind.CoGroup;
    }

    public final boolean isMerge() {
        return this.kind == Kind.Merge;
    }

    public final boolean isJoin() {
        return this.kind == Kind.Join;
    }

    public int getNumSelfJoins() {
        return this.numSelfJoins;
    }

    boolean isSelfJoin() {
        return this.numSelfJoins != 0;
    }

    @Override
    public Scope outgoingScopeFor(Set<Scope> incomingScopes) {
        Map<String, Fields> groupingSelectors = this.resolveGroupingSelectors(incomingScopes);
        Map<String, Fields> sortingSelectors = this.resolveSortingSelectors(incomingScopes);
        Fields declared = this.resolveDeclared(incomingScopes);
        Fields outGroupingFields = this.resultGroupFields;
        if (outGroupingFields == null && this.isCoGroup()) {
            outGroupingFields = this.createJoinFields(incomingScopes, groupingSelectors, declared);
        }
        return new Scope(this.getName(), declared, outGroupingFields, groupingSelectors, sortingSelectors, declared, this.isGroupBy());
    }

    private Fields createJoinFields(Set<Scope> incomingScopes, Map<String, Fields> groupingSelectors, Fields declared) {
        if (declared.isNone()) {
            declared = Fields.UNKNOWN;
        }
        HashMap<String, Fields> incomingFields = new HashMap<String, Fields>();
        for (Scope scope : incomingScopes) {
            incomingFields.put(scope.getName(), scope.getIncomingSpliceFields());
        }
        Fields outGroupingFields = Fields.NONE;
        int offset = 0;
        for (Pipe pipe : this.pipes) {
            String pipeName = pipe.getName();
            Fields pipeGroupingSelector = groupingSelectors.get(pipeName);
            Fields incomingField = (Fields)incomingFields.get(pipeName);
            if (!pipeGroupingSelector.isNone()) {
                Fields offsetFields = incomingField.selectPos(pipeGroupingSelector, offset);
                Fields resolvedSelect = declared.select(offsetFields);
                outGroupingFields = outGroupingFields.append(resolvedSelect);
            }
            offset += incomingField.size();
        }
        return outGroupingFields;
    }

    Map<String, Fields> resolveGroupingSelectors(Set<Scope> incomingScopes) {
        try {
            Map<String, Fields> groupingSelectors = this.getKeySelectors();
            Map<String, Fields> groupingFields = this.resolveSelectorsAgainstIncoming(incomingScopes, groupingSelectors, "grouping");
            if (!this.verifySameSize(groupingFields)) {
                throw new OperatorException(this, "all grouping fields must be same size: " + this.toString());
            }
            this.verifySameTypes(groupingSelectors, groupingFields);
            return groupingFields;
        }
        catch (FieldsResolverException exception) {
            throw new OperatorException((Pipe)this, OperatorException.Kind.grouping, exception.getSourceFields(), exception.getSelectorFields(), (Throwable)exception);
        }
        catch (RuntimeException exception) {
            throw new OperatorException(this, "could not resolve grouping selector in: " + this, exception);
        }
    }

    private boolean verifySameTypes(Map<String, Fields> groupingSelectors, Map<String, Fields> groupingFields) {
        boolean[] hasComparator = new boolean[groupingFields.values().iterator().next().size()];
        for (Map.Entry<String, Fields> entry2 : groupingSelectors.entrySet()) {
            Comparator[] comparatorsArray = entry2.getValue().getComparators();
            for (int i = 0; i < comparatorsArray.length; ++i) {
                hasComparator[i] = hasComparator[i] || comparatorsArray[i] != null;
            }
        }
        Iterator<Fields> iterator2 = groupingFields.values().iterator();
        Fields lhsFields = iterator2.next();
        Type[] lhsTypes = lhsFields.getTypes();
        if (lhsTypes == null) {
            return true;
        }
        while (iterator2.hasNext()) {
            Fields rhsFields = iterator2.next();
            Type[] rhsTypes = rhsFields.getTypes();
            if (rhsTypes == null) {
                return true;
            }
            for (int i = 0; i < lhsTypes.length; ++i) {
                if (hasComparator[i]) continue;
                Type lhs = lhsTypes[i];
                Type rhs = rhsTypes[i];
                if ((lhs = this.getCanonicalType(lhs)).equals(rhs = this.getCanonicalType(rhs))) continue;
                Fields lhsError = new Fields(lhsFields.get(i), lhsFields.getType(i));
                Fields rhsError = new Fields(rhsFields.get(i), rhsFields.getType(i));
                throw new OperatorException(this, "grouping fields must declare same types:" + lhsError.printVerbose() + " not same as " + rhsError.printVerbose());
            }
        }
        return true;
    }

    private Type getCanonicalType(Type type) {
        if (type instanceof CoercibleType) {
            type = ((CoercibleType)((Object)type)).getCanonicalType();
        }
        if (type instanceof Class) {
            type = Coercions.asNonPrimitive(type);
        }
        return type;
    }

    private boolean verifySameSize(Map<String, Fields> groupingFields) {
        Iterator<Fields> iterator2 = groupingFields.values().iterator();
        int size2 = iterator2.next().size();
        while (iterator2.hasNext()) {
            Fields groupingField = iterator2.next();
            if (groupingField.size() != size2) {
                return false;
            }
            size2 = groupingField.size();
        }
        return true;
    }

    private Map<String, Fields> resolveSelectorsAgainstIncoming(Set<Scope> incomingScopes, Map<String, Fields> selectors, String type) {
        HashMap<String, Fields> resolvedFields = new HashMap<String, Fields>();
        for (Scope incomingScope : incomingScopes) {
            Fields selector = selectors.get(incomingScope.getName());
            if (selector == null) {
                throw new OperatorException(this, "no " + type + " selector found for: " + incomingScope.getName());
            }
            Fields incomingFields = selector.isNone() ? Fields.NONE : (selector.isAll() ? incomingScope.getIncomingSpliceFields() : (selector.isGroup() ? incomingScope.getOutGroupingFields() : (selector.isValues() ? incomingScope.getOutValuesFields().subtract(incomingScope.getOutGroupingFields()) : incomingScope.getIncomingSpliceFields().select(selector))));
            resolvedFields.put(incomingScope.getName(), incomingFields);
        }
        return resolvedFields;
    }

    Map<String, Fields> resolveSortingSelectors(Set<Scope> incomingScopes) {
        try {
            if (this.getSortingSelectors().isEmpty()) {
                return null;
            }
            return this.resolveSelectorsAgainstIncoming(incomingScopes, this.getSortingSelectors(), "sorting");
        }
        catch (FieldsResolverException exception) {
            throw new OperatorException((Pipe)this, OperatorException.Kind.sorting, exception.getSourceFields(), exception.getSelectorFields(), (Throwable)exception);
        }
        catch (RuntimeException exception) {
            throw new OperatorException(this, "could not resolve sorting selector in: " + this, exception);
        }
    }

    @Override
    public Fields resolveIncomingOperationPassThroughFields(Scope incomingScope) {
        return incomingScope.getIncomingSpliceFields();
    }

    Fields resolveDeclared(Set<Scope> incomingScopes) {
        try {
            Fields declaredFields = this.getJoinDeclaredFields();
            if (declaredFields != null && declaredFields.isNone()) {
                if (!this.isCoGroup()) {
                    throw new IllegalArgumentException("Fields.NONE may only be declared as the join fields when using a CoGroup");
                }
                return Fields.NONE;
            }
            if (declaredFields != null) {
                if (incomingScopes.size() != this.pipes.size() && this.isSelfJoin()) {
                    throw new OperatorException(this, "self joins without intermediate operators are not permitted, see 'numSelfJoins' constructor or identity function");
                }
                int size2 = 0;
                boolean foundUnknown = false;
                List<Fields> appendableFields = this.getOrderedResolvedFields(incomingScopes);
                for (Fields fields2 : appendableFields) {
                    foundUnknown = foundUnknown || fields2.isUnknown();
                    size2 += fields2.size();
                }
                if (!foundUnknown && declaredFields.size() != size2 * (this.numSelfJoins + 1)) {
                    if (this.isSelfJoin()) {
                        throw new OperatorException(this, "declared grouped fields not same size as grouped values, declared: " + declaredFields.printVerbose() + " != size: " + size2 * (this.numSelfJoins + 1));
                    }
                    throw new OperatorException(this, "declared grouped fields not same size as grouped values, declared: " + declaredFields.printVerbose() + " resolved: " + Util.print(appendableFields, ""));
                }
                int i = 0;
                for (Fields appendableField : appendableFields) {
                    Type[] types2 = appendableField.getTypes();
                    if (types2 == null) {
                        i += appendableField.size();
                        continue;
                    }
                    for (Type type : types2) {
                        if (type != null) {
                            declaredFields = declaredFields.applyType(Integer.valueOf(i), type);
                        }
                        ++i;
                    }
                }
                return declaredFields;
            }
            if (this.isGroupBy() || this.isMerge()) {
                Iterator<Scope> iterator2 = incomingScopes.iterator();
                Fields commonFields = iterator2.next().getIncomingSpliceFields();
                while (iterator2.hasNext()) {
                    Scope incomingScope = iterator2.next();
                    Fields fields3 = incomingScope.getIncomingSpliceFields();
                    if (commonFields.equalsFields(fields3)) continue;
                    throw new OperatorException(this, "merged streams must declare the same field names, in the same order, expected: " + commonFields.printVerbose() + " found: " + fields3.printVerbose());
                }
                return commonFields;
            }
            List<Fields> appendableFields = this.getOrderedResolvedFields(incomingScopes);
            Fields appendedFields = new Fields(new Comparable[0]);
            try {
                for (Fields appendableField : appendableFields) {
                    appendedFields = appendedFields.append(appendableField);
                }
            }
            catch (TupleException exception) {
                String fields4 = "";
                for (Fields appendableField : appendableFields) {
                    fields4 = fields4 + appendableField.print();
                }
                throw new OperatorException(this, "found duplicate field names in joined tuple stream: " + fields4, exception);
            }
            return appendedFields;
        }
        catch (OperatorException exception) {
            throw exception;
        }
        catch (RuntimeException exception) {
            throw new OperatorException(this, "could not resolve declared fields in: " + this, exception);
        }
    }

    public Fields getJoinDeclaredFields() {
        Fields declaredFields = this.getDeclaredFields();
        if (!(this.joiner instanceof DeclaresResults)) {
            return declaredFields;
        }
        if (declaredFields == null && ((DeclaresResults)((Object)this.joiner)).getFieldDeclaration() != null) {
            declaredFields = ((DeclaresResults)((Object)this.joiner)).getFieldDeclaration();
        }
        return declaredFields;
    }

    private List<Fields> getOrderedResolvedFields(Set<Scope> incomingScopes) {
        HashMap<String, Scope> scopesMap = new HashMap<String, Scope>();
        for (Scope incomingScope : incomingScopes) {
            scopesMap.put(incomingScope.getName(), incomingScope);
        }
        ArrayList<Fields> appendableFields = new ArrayList<Fields>();
        for (Pipe pipe : this.pipes) {
            appendableFields.add(((Scope)scopesMap.get(pipe.getName())).getIncomingSpliceFields());
        }
        return appendableFields;
    }

    @Override
    public boolean isEquivalentTo(FlowElement element) {
        boolean equivalentTo = super.isEquivalentTo(element);
        if (!equivalentTo) {
            return equivalentTo;
        }
        Splice splice = (Splice)element;
        if (!((Object)this.keyFieldsMap).equals(splice.keyFieldsMap)) {
            return false;
        }
        return ((Object)this.pipes).equals(splice.pipes);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Splice splice = (Splice)object;
        if (this.spliceName != null ? !this.spliceName.equals(splice.spliceName) : splice.spliceName != null) {
            return false;
        }
        if (this.keyFieldsMap != null ? !((Object)this.keyFieldsMap).equals(splice.keyFieldsMap) : splice.keyFieldsMap != null) {
            return false;
        }
        return !(this.pipes != null ? !((Object)this.pipes).equals(splice.pipes) : splice.pipes != null);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.pipes != null ? ((Object)this.pipes).hashCode() : 0);
        result2 = 31 * result2 + (this.keyFieldsMap != null ? ((Object)this.keyFieldsMap).hashCode() : 0);
        result2 = 31 * result2 + (this.spliceName != null ? this.spliceName.hashCode() : 0);
        return result2;
    }

    @Override
    public String toString() {
        StringBuilder buffer2 = new StringBuilder(super.toString());
        buffer2.append("[by:");
        for (String name2 : this.keyFieldsMap.keySet()) {
            if (this.keyFieldsMap.size() > 1) {
                buffer2.append(" ").append(name2).append(":");
            }
            buffer2.append(this.keyFieldsMap.get(name2).printVerbose());
        }
        if (this.isSelfJoin()) {
            buffer2.append("[numSelfJoins:").append(this.numSelfJoins).append("]");
        }
        buffer2.append("]");
        return buffer2.toString();
    }

    @Override
    protected void printInternal(StringBuffer buffer2, Scope scope) {
        super.printInternal(buffer2, scope);
        Map<String, Fields> map2 = scope.getKeySelectors();
        if (map2 != null) {
            buffer2.append("[by:");
            for (Map.Entry<String, Fields> entry2 : this.keyFieldsMap.entrySet()) {
                String name2 = entry2.getKey();
                if (map2.size() > 1) {
                    buffer2.append(name2).append(":");
                }
                buffer2.append(map2.get(name2).print());
            }
            if (this.isSelfJoin()) {
                buffer2.append("[numSelfJoins:").append(this.numSelfJoins).append("]");
            }
            buffer2.append("]");
        }
    }

    static enum Kind {
        GroupBy,
        CoGroup,
        Merge,
        Join;

    }
}

