/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe;

import cascading.flow.FlowElement;
import cascading.flow.planner.Scope;
import cascading.operation.AssertionLevel;
import cascading.operation.BaseOperation;
import cascading.operation.Operation;
import cascading.operation.PlannedOperation;
import cascading.operation.PlannerLevel;
import cascading.pipe.OperatorException;
import cascading.pipe.Pipe;
import cascading.tuple.Fields;
import cascading.tuple.FieldsResolverException;
import cascading.tuple.TupleException;
import java.util.Set;

public abstract class Operator
extends Pipe {
    protected final Operation operation;
    protected Fields argumentSelector = Fields.ALL;
    protected Fields outputSelector = Fields.RESULTS;
    protected PlannerLevel plannerLevel;

    protected Operator(Operation operation) {
        this.operation = operation;
        this.verifyOperation();
    }

    protected Operator(String name2, Operation operation) {
        super(name2);
        this.operation = operation;
        this.verifyOperation();
    }

    protected Operator(String name2, Operation operation, Fields outputSelector) {
        super(name2);
        this.operation = operation;
        this.outputSelector = outputSelector;
        this.verifyOperation();
    }

    protected Operator(String name2, Fields argumentSelector, Operation operation) {
        super(name2);
        this.operation = operation;
        this.argumentSelector = argumentSelector;
        this.verifyOperation();
    }

    protected Operator(String name2, Fields argumentSelector, Operation operation, Fields outputSelector) {
        super(name2);
        this.operation = operation;
        this.argumentSelector = argumentSelector;
        this.outputSelector = outputSelector;
        this.verifyOperation();
    }

    protected Operator(Pipe previous, Operation operation) {
        super(previous);
        this.operation = operation;
        this.verifyOperation();
    }

    protected Operator(Pipe previous, Fields argumentSelector, Operation operation) {
        super(previous);
        this.operation = operation;
        this.argumentSelector = argumentSelector;
        this.verifyOperation();
    }

    protected Operator(Pipe previous, Fields argumentSelector, Operation operation, Fields outputSelector) {
        super(previous);
        this.operation = operation;
        this.argumentSelector = argumentSelector;
        this.outputSelector = outputSelector;
        this.verifyOperation();
    }

    protected Operator(Pipe previous, Operation operation, Fields outputSelector) {
        super(previous);
        this.operation = operation;
        this.outputSelector = outputSelector;
        this.verifyOperation();
    }

    protected Operator(String name2, PlannerLevel plannerLevel, PlannedOperation operation, Fields outputSelector) {
        super(name2);
        this.plannerLevel = plannerLevel;
        this.operation = operation;
        this.outputSelector = outputSelector;
        this.verifyOperation();
    }

    protected Operator(String name2, Fields argumentSelector, PlannerLevel plannerLevel, PlannedOperation operation, Fields outputSelector) {
        super(name2);
        this.plannerLevel = plannerLevel;
        this.operation = operation;
        this.argumentSelector = argumentSelector;
        this.outputSelector = outputSelector;
        this.verifyOperation();
    }

    protected Operator(Pipe previous, PlannerLevel plannerLevel, PlannedOperation operation, Fields outputSelector) {
        super(previous);
        this.plannerLevel = plannerLevel;
        this.operation = operation;
        this.outputSelector = outputSelector;
        this.verifyOperation();
    }

    protected Operator(Pipe previous, Fields argumentSelector, PlannerLevel plannerLevel, PlannedOperation operation, Fields outputSelector) {
        super(previous);
        this.plannerLevel = plannerLevel;
        this.operation = operation;
        this.argumentSelector = argumentSelector;
        this.outputSelector = outputSelector;
        this.verifyOperation();
    }

    protected void verifyOperation() {
        if (this.operation == null) {
            throw new IllegalArgumentException("operation may not be null");
        }
        if (this.argumentSelector == null) {
            throw new IllegalArgumentException("argumentSelector may not be null");
        }
        if (this.outputSelector == null) {
            throw new IllegalArgumentException("outputSelector may not be null");
        }
        if (this.operation instanceof PlannedOperation) {
            if (this.plannerLevel == null) {
                throw new IllegalArgumentException("planner level may not be null");
            }
            if (this.plannerLevel.isNoneLevel()) {
                throw new IllegalArgumentException("given planner level: " + this.plannerLevel.getClass().getName() + ", may not be NONE");
            }
        }
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Fields getArgumentSelector() {
        return this.argumentSelector;
    }

    public Fields getFieldDeclaration() {
        return this.operation.getFieldDeclaration();
    }

    public Fields getOutputSelector() {
        return this.outputSelector;
    }

    @Deprecated
    public AssertionLevel getAssertionLevel() {
        return (AssertionLevel)this.plannerLevel;
    }

    public PlannerLevel getPlannerLevel() {
        return this.plannerLevel;
    }

    public boolean hasPlannerLevel() {
        return this.plannerLevel != null;
    }

    protected Fields resolveRemainderFields(Set<Scope> incomingScopes, Fields argumentFields) {
        Fields fields2 = this.resolveIncomingOperationArgumentFields(this.getFirst(incomingScopes));
        if (fields2.isUnknown()) {
            return fields2;
        }
        return fields2.subtract(argumentFields);
    }

    @Override
    public abstract Scope outgoingScopeFor(Set<Scope> var1);

    void verifyDeclaredFields(Fields declared) {
        if (declared.isDefined() && declared.size() == 0) {
            throw new OperatorException(this, "field declaration: " + this.getFieldDeclaration().printVerbose() + ", resolves to an empty field set, current grouping is on all fields");
        }
    }

    void verifyOutputSelector(Fields outputSelector) {
        if (outputSelector.isDefined() && outputSelector.size() == 0) {
            throw new OperatorException(this, "output selector: " + this.getOutputSelector().printVerbose() + ", resolves to an empty field set, current grouping is on all fields");
        }
    }

    void verifyArguments(Fields argumentSelector) {
        if (argumentSelector.isUnknown()) {
            return;
        }
        if (this.operation.getNumArgs() != Integer.MAX_VALUE && argumentSelector.size() < this.operation.getNumArgs()) {
            throw new OperatorException(this, "resolved wrong number of arguments: " + argumentSelector.printVerbose() + ", expected: " + this.operation.getNumArgs());
        }
    }

    Fields resolveOutgoingSelector(Set<Scope> incomingScopes, Fields argumentFields, Fields declaredFields) {
        Scope incomingScope = this.getFirst(incomingScopes);
        Fields outputSelector = this.getOutputSelector();
        if (outputSelector.isResults()) {
            return declaredFields;
        }
        if (outputSelector.isArguments()) {
            return argumentFields;
        }
        if (outputSelector.isGroup()) {
            return incomingScope.getOutGroupingFields();
        }
        if (outputSelector.isValues()) {
            return incomingScope.getOutGroupingValueFields();
        }
        Fields incomingFields = this.resolveIncomingOperationPassThroughFields(incomingScope);
        if (outputSelector.isSwap()) {
            return Fields.asDeclaration(incomingFields.subtract(argumentFields)).append(declaredFields);
        }
        try {
            return Fields.resolve(outputSelector, Fields.asDeclaration(incomingFields), declaredFields);
        }
        catch (TupleException exception) {
            throw new OperatorException((Pipe)this, incomingFields, declaredFields, outputSelector, (Throwable)exception);
        }
    }

    Fields resolveArgumentSelector(Set<Scope> incomingScopes) {
        Fields argumentSelector = this.getArgumentSelector();
        try {
            Scope incomingScope = this.getFirst(incomingScopes);
            if (argumentSelector.isAll()) {
                return this.resolveIncomingOperationArgumentFields(incomingScope);
            }
            if (argumentSelector.isGroup()) {
                return incomingScope.getOutGroupingFields();
            }
            if (argumentSelector.isValues()) {
                return incomingScope.getOutGroupingValueFields();
            }
            return this.resolveIncomingOperationArgumentFields(incomingScope).select(argumentSelector);
        }
        catch (FieldsResolverException exception) {
            throw new OperatorException((Pipe)this, OperatorException.Kind.argument, exception.getSourceFields(), argumentSelector, (Throwable)exception);
        }
        catch (Exception exception) {
            throw new OperatorException(this, "unable to resolve argument selector: " + argumentSelector.printVerbose(), exception);
        }
    }

    Fields resolveDeclared(Set<Scope> incomingScopes, Fields arguments) {
        Fields fieldDeclaration = this.getFieldDeclaration();
        if (this.getOutputSelector().isReplace()) {
            if (arguments.isDefined() && fieldDeclaration.isDefined() && arguments.size() != fieldDeclaration.size()) {
                throw new OperatorException(this, "during REPLACE both the arguments selector and field declaration must be the same size, arguments: " + arguments.printVerbose() + " declaration: " + fieldDeclaration.printVerbose());
            }
            if (fieldDeclaration.isArguments()) {
                return arguments;
            }
            return arguments.project(fieldDeclaration);
        }
        try {
            Scope incomingScope = this.getFirst(incomingScopes);
            if (fieldDeclaration.isUnknown()) {
                return fieldDeclaration;
            }
            if (fieldDeclaration.isArguments()) {
                return Fields.asDeclaration(arguments);
            }
            if (fieldDeclaration.isAll()) {
                return this.resolveIncomingOperationPassThroughFields(incomingScope);
            }
            if (fieldDeclaration.isGroup()) {
                return incomingScope.getOutGroupingFields();
            }
            if (fieldDeclaration.isValues()) {
                return incomingScope.getOutGroupingValueFields();
            }
        }
        catch (Exception exception) {
            throw new OperatorException(this, "could not resolve declared fields in:  " + this, exception);
        }
        return fieldDeclaration;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.operation + "]";
    }

    @Override
    protected void printInternal(StringBuffer buffer2, Scope scope) {
        super.printInternal(buffer2, scope);
        buffer2.append("[");
        BaseOperation.printOperationInternal(this.operation, buffer2, scope);
        buffer2.append("]");
    }

    @Override
    public boolean isEquivalentTo(FlowElement element) {
        boolean equivalentTo = super.isEquivalentTo(element);
        if (!equivalentTo) {
            return false;
        }
        Operator operator = (Operator)element;
        equivalentTo = this.argumentSelector.equals(operator.argumentSelector);
        if (!equivalentTo) {
            return false;
        }
        if (!this.operation.equals(operator.operation)) {
            return false;
        }
        equivalentTo = this.outputSelector.equals(operator.outputSelector);
        return equivalentTo;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Operator operator = (Operator)object;
        if (this.argumentSelector != null ? !this.argumentSelector.equals(operator.argumentSelector) : operator.argumentSelector != null) {
            return false;
        }
        if (this.operation != null ? !this.operation.equals(operator.operation) : operator.operation != null) {
            return false;
        }
        return !(this.outputSelector != null ? !this.outputSelector.equals(operator.outputSelector) : operator.outputSelector != null);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.operation != null ? this.operation.hashCode() : 0);
        result2 = 31 * result2 + (this.argumentSelector != null ? this.argumentSelector.hashCode() : 0);
        result2 = 31 * result2 + (this.outputSelector != null ? this.outputSelector.hashCode() : 0);
        return result2;
    }
}

