/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.xml;

import cascading.flow.FlowProcess;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationException;
import cascading.operation.xml.XPathOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.util.Pair;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XPathParser
extends XPathOperation
implements Function<Pair<DocumentBuilder, Tuple>> {
    private static final Logger LOG = LoggerFactory.getLogger(XPathParser.class);

    public XPathParser(Fields fieldDeclaration, String[][] namespaces, String ... paths) {
        super(1, fieldDeclaration, namespaces, paths);
        if (!fieldDeclaration.isSubstitution() && fieldDeclaration.size() != paths.length) {
            throw new IllegalArgumentException("declared fields and given xpath expressions are not the same size: " + fieldDeclaration.print() + " paths: " + paths.length);
        }
    }

    public XPathParser(Fields fieldDeclaration, String ... paths) {
        super(1, fieldDeclaration, (String[][])null, paths);
        if (!fieldDeclaration.isSubstitution() && fieldDeclaration.size() != paths.length) {
            throw new IllegalArgumentException("declared fields and given xpath expressions are not the same size: " + fieldDeclaration.print() + " paths: " + paths.length);
        }
    }

    @Override
    public void operate(FlowProcess flowProcess, FunctionCall<Pair<DocumentBuilder, Tuple>> functionCall) {
        Tuple tuple = (Tuple)((Pair)functionCall.getContext()).getRhs();
        tuple.clear();
        String argument2 = functionCall.getArguments().getString(Integer.valueOf(0));
        Document document2 = this.parseDocument((DocumentBuilder)((Pair)functionCall.getContext()).getLhs(), argument2);
        for (int i = 0; i < this.getExpressions().size(); ++i) {
            try {
                NodeList value2 = (NodeList)this.getExpressions().get(i).evaluate(document2, XPathConstants.NODESET);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("xpath: {} was: {}", (Object)this.paths[i], (Object)(value2 != null && value2.getLength() != 0 ? 1 : 0));
                }
                if (value2 != null && value2.getLength() != 0) {
                    tuple.add((Comparable)((Object)this.writeAsXML(value2.item(0))));
                    continue;
                }
                tuple.add((Comparable)((Object)""));
                continue;
            }
            catch (XPathExpressionException exception) {
                throw new OperationException("could not evaluate xpath expression: " + this.paths[i], exception);
            }
        }
        functionCall.getOutputCollector().add(tuple);
    }
}

