/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.xml;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.OperationCall;
import cascading.operation.OperationException;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.util.Pair;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XPathOperation
extends BaseOperation<Pair<DocumentBuilder, Tuple>> {
    public static final String[][] NAMESPACE_XHTML = new String[][]{{"xhtml", "http://www.w3.org/1999/xhtml"}};
    private static final Logger LOG = LoggerFactory.getLogger(XPathOperation.class);
    protected final String[][] namespaces;
    protected final String[] paths;
    private transient XPath xPath;
    private transient Transformer transformer;
    private transient List<XPathExpression> expressions;

    protected XPathOperation(int numArgs, Fields fieldDeclaration, String[][] namespaces, String ... paths) {
        super(numArgs, fieldDeclaration);
        this.namespaces = namespaces;
        this.paths = paths;
        if (paths == null || paths.length == 0) {
            throw new IllegalArgumentException("a xpath expression must be given");
        }
    }

    protected XPathOperation(int numArgs, String[][] namespaces, String ... paths) {
        super(numArgs);
        this.namespaces = namespaces;
        this.paths = paths;
        if (paths == null || paths.length == 0) {
            throw new IllegalArgumentException("a xpath expression must be given");
        }
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Pair<DocumentBuilder, Tuple>> operationCall) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            operationCall.setContext(new Pair<DocumentBuilder, Tuple>(factory.newDocumentBuilder(), Tuple.size(1)));
        }
        catch (ParserConfigurationException exception) {
            throw new OperationException("could not create document builder", exception);
        }
    }

    public XPath getXPath() {
        if (this.xPath != null) {
            return this.xPath;
        }
        XPathFactory factory = XPathFactory.newInstance();
        this.xPath = factory.newXPath();
        if (this.namespaces != null) {
            MutableNamespaceContext namespaceContext = new MutableNamespaceContext();
            for (String[] namespace : this.namespaces) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("adding namespace: {}:{}", (Object)namespace[0], (Object)namespace[1]);
                }
                namespaceContext.addNamespace(namespace[0], namespace[1]);
            }
            this.xPath.setNamespaceContext(namespaceContext);
        }
        return this.xPath;
    }

    public Transformer getTransformer() throws TransformerConfigurationException {
        if (this.transformer != null) {
            return this.transformer;
        }
        this.transformer = TransformerFactory.newInstance().newTransformer();
        this.transformer.setOutputProperty("omit-xml-declaration", "yes");
        return this.transformer;
    }

    protected String writeAsXML(Node node) {
        StringWriter stringWriter = new StringWriter();
        StreamResult result2 = new StreamResult(stringWriter);
        DOMSource source2 = new DOMSource(node);
        try {
            this.getTransformer().transform(source2, result2);
        }
        catch (TransformerException exception) {
            throw new OperationException("writing to xml failed", exception);
        }
        return stringWriter.toString();
    }

    protected List<XPathExpression> getExpressions() {
        if (this.expressions != null) {
            return this.expressions;
        }
        this.expressions = new ArrayList<XPathExpression>();
        for (String path : this.paths) {
            try {
                this.expressions.add(this.getXPath().compile(path));
            }
            catch (XPathExpressionException exception) {
                throw new OperationException("could not compile xpath expression", exception);
            }
        }
        return this.expressions;
    }

    protected Document parseDocument(DocumentBuilder documentBuilder, String argument2) {
        Document document2;
        try {
            document2 = documentBuilder.parse(new InputSource(new StringReader(argument2)));
        }
        catch (SAXException exception) {
            throw new OperationException("could not parse xml document", exception);
        }
        catch (IOException exception) {
            throw new OperationException("could not parse xml document", exception);
        }
        return document2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof XPathOperation)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        XPathOperation that = (XPathOperation)object;
        if (this.expressions != null ? !((Object)this.expressions).equals(that.expressions) : that.expressions != null) {
            return false;
        }
        return Arrays.equals(this.paths, that.paths);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.paths != null ? Arrays.hashCode(this.paths) : 0);
        result2 = 31 * result2 + (this.expressions != null ? ((Object)this.expressions).hashCode() : 0);
        return result2;
    }

    class MutableNamespaceContext
    implements NamespaceContext {
        private final Map<String, String> map = new HashMap<String, String>();

        public void addNamespace(String prefix, String namespaceURI) {
            this.map.put(prefix, namespaceURI);
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.map.get(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            for (String prefix : this.map.keySet()) {
                if (!this.map.get(prefix).equals(namespaceURI)) continue;
                return prefix;
            }
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            ArrayList<String> prefixes = new ArrayList<String>();
            for (String prefix : this.map.keySet()) {
                if (!this.map.get(prefix).equals(namespaceURI)) continue;
                prefixes.add(prefix);
            }
            return prefixes.iterator();
        }
    }
}

