/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.xml;

import cascading.flow.FlowProcess;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationException;
import cascading.operation.xml.XPathOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.util.Pair;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XPathGenerator
extends XPathOperation
implements Function<Pair<DocumentBuilder, Tuple>> {
    private static final Logger LOG = LoggerFactory.getLogger(XPathGenerator.class);

    public XPathGenerator(Fields fieldDeclaration, String[][] namespaces, String ... paths) {
        super(1, fieldDeclaration, namespaces, paths);
        if (fieldDeclaration.size() != 1) {
            throw new IllegalArgumentException("only one field can be declared: " + fieldDeclaration.print());
        }
    }

    @Override
    public void operate(FlowProcess flowProcess, FunctionCall<Pair<DocumentBuilder, Tuple>> functionCall) {
        TupleEntry input2 = functionCall.getArguments();
        if (input2.getObject(0) == null || !(input2.getObject(0) instanceof String)) {
            return;
        }
        String value2 = input2.getString(Integer.valueOf(0));
        if (value2.length() == 0) {
            return;
        }
        Document document2 = this.parseDocument((DocumentBuilder)((Pair)functionCall.getContext()).getLhs(), value2);
        for (int i = 0; i < this.getExpressions().size(); ++i) {
            try {
                NodeList nodeList = (NodeList)this.getExpressions().get(i).evaluate(document2, XPathConstants.NODESET);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("xpath: {} was: {}", (Object)this.paths[i], (Object)(nodeList != null && nodeList.getLength() != 0 ? 1 : 0));
                }
                if (nodeList == null) continue;
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    ((Tuple)((Pair)functionCall.getContext()).getRhs()).set(0, this.writeAsXML(nodeList.item(j)));
                    functionCall.getOutputCollector().add((Tuple)((Pair)functionCall.getContext()).getRhs());
                }
                continue;
            }
            catch (XPathExpressionException exception) {
                throw new OperationException("could not evaluate xpath expression: " + this.paths[i], exception);
            }
        }
    }
}

