/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.xml;

import cascading.flow.FlowProcess;
import cascading.operation.Filter;
import cascading.operation.FilterCall;
import cascading.operation.OperationException;
import cascading.operation.xml.XPathOperation;
import cascading.tuple.Tuple;
import cascading.util.Pair;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class XPathFilter
extends XPathOperation
implements Filter<Pair<DocumentBuilder, Tuple>> {
    private static final Logger LOG = LoggerFactory.getLogger(XPathFilter.class);
    private boolean removeMatch = false;

    public XPathFilter(String[][] namespaces, String path) {
        super(1, namespaces, path);
    }

    public XPathFilter(boolean removeMatch, String[][] namespaces, String path) {
        super(1, namespaces, path);
        this.removeMatch = removeMatch;
    }

    @Override
    public boolean isRemove(FlowProcess flowProcess, FilterCall<Pair<DocumentBuilder, Tuple>> filterCall) {
        String argument2 = filterCall.getArguments().getString(Integer.valueOf(0));
        Document document2 = this.parseDocument((DocumentBuilder)((Pair)filterCall.getContext()).getLhs(), argument2);
        XPathExpression expression = this.getExpressions().get(0);
        try {
            boolean value2 = (Boolean)expression.evaluate(document2, XPathConstants.BOOLEAN);
            LOG.debug("xpath: {} matches: {}", (Object)this.paths[0], (Object)value2);
            return value2 == this.removeMatch;
        }
        catch (XPathExpressionException exception) {
            throw new OperationException("could not evaluate xpath expression: " + this.paths[0], exception);
        }
    }
}

