/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.xml;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.ccil.cowan.tagsoup.HTMLSchema;
import org.ccil.cowan.tagsoup.Parser;
import org.ccil.cowan.tagsoup.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class TagSoupParser
extends BaseOperation
implements Function {
    private static final Logger LOG = LoggerFactory.getLogger(TagSoupParser.class);
    private Map<String, Boolean> features;
    private transient HTMLSchema schema;
    private transient Parser parser;

    @ConstructorProperties(value={"fieldDeclaration"})
    public TagSoupParser(Fields fieldDeclaration) {
        super(1, fieldDeclaration);
        if (fieldDeclaration.size() != 1) {
            throw new IllegalArgumentException("fieldDeclaration may only declare one field name: " + fieldDeclaration.print());
        }
    }

    private HTMLSchema getSchema() {
        if (this.schema == null) {
            this.schema = new HTMLSchema();
        }
        return this.schema;
    }

    private Parser getParser() throws SAXNotSupportedException, SAXNotRecognizedException {
        if (this.parser != null) {
            return this.parser;
        }
        this.parser = new Parser();
        this.parser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", this.getSchema());
        if (this.features != null) {
            for (Map.Entry<String, Boolean> entry2 : this.features.entrySet()) {
                this.parser.setFeature(entry2.getKey(), entry2.getValue());
            }
        }
        return this.parser;
    }

    public void setFeature(String feature, boolean value2) {
        if (this.features == null) {
            this.features = new HashMap<String, Boolean>();
        }
        this.features.put(feature, value2);
    }

    public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
        try {
            StringWriter writer = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(writer);
            xmlWriter.setPrefix(this.getSchema().getURI(), "");
            xmlWriter.setOutputProperty("omit-xml-declaration", "yes");
            InputSource source2 = new InputSource(new StringReader((String)functionCall.getArguments().getObject(0)));
            this.getParser().setContentHandler(xmlWriter);
            this.getParser().parse(source2);
            functionCall.getOutputCollector().add(new Tuple(writer.getBuffer().toString()));
        }
        catch (SAXNotRecognizedException exception) {
            LOG.warn("ignoring TagSoup exception", exception);
        }
        catch (SAXNotSupportedException exception) {
            LOG.warn("ignoring TagSoup exception", exception);
        }
        catch (IOException exception) {
            LOG.warn("ignoring TagSoup exception", exception);
        }
        catch (SAXException exception) {
            LOG.warn("ignoring TagSoup exception", exception);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TagSoupParser)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        TagSoupParser that = (TagSoupParser)object;
        return !(this.features != null ? !((Object)this.features).equals(that.features) : that.features != null);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.features != null ? ((Object)this.features).hashCode() : 0);
        return result2;
    }
}

