/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.text;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.beans.ConstructorProperties;

public class FieldFormatter
extends BaseOperation<Tuple>
implements Function<Tuple> {
    public static final String FIELD_NAME = "formatted";
    private String format = null;

    @ConstructorProperties(value={"format"})
    public FieldFormatter(String format2) {
        super(new Fields(new Comparable[]{FIELD_NAME}));
        this.format = format2;
    }

    @ConstructorProperties(value={"fieldDeclaration", "format"})
    public FieldFormatter(Fields fieldDeclaration, String format2) {
        super(fieldDeclaration);
        this.format = format2;
        if (fieldDeclaration.size() != 1) {
            throw new IllegalArgumentException("fieldDeclaration may only declare one field name, got " + fieldDeclaration.print());
        }
    }

    public String getFormat() {
        return this.format;
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Tuple> operationCall) {
        operationCall.setContext(Tuple.size(1));
    }

    @Override
    public void operate(FlowProcess flowProcess, FunctionCall<Tuple> functionCall) {
        ((Tuple)functionCall.getContext()).set(0, functionCall.getArguments().getTuple().format(this.format));
        functionCall.getOutputCollector().add((Tuple)functionCall.getContext());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FieldFormatter)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        FieldFormatter that = (FieldFormatter)object;
        return !(this.format != null ? !this.format.equals(that.format) : that.format != null);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.format != null ? this.format.hashCode() : 0);
        return result2;
    }
}

