/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.text;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.OperationCall;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.util.Pair;
import java.beans.ConstructorProperties;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateOperation
extends BaseOperation<Pair<SimpleDateFormat, Tuple>> {
    protected TimeZone zone;
    protected Locale locale;
    final String dateFormatString;

    @ConstructorProperties(value={"numArgs", "fieldDeclaration", "dateFormatString"})
    public DateOperation(int numArgs, Fields fieldDeclaration, String dateFormatString) {
        super(numArgs, fieldDeclaration);
        this.dateFormatString = dateFormatString;
        if (!fieldDeclaration.isSubstitution() && fieldDeclaration.size() != 1) {
            throw new IllegalArgumentException("fieldDeclaration may only declare one field name, got " + fieldDeclaration.print());
        }
    }

    @ConstructorProperties(value={"numArgs", "fieldDeclaration", "dateFormatString", "zone", "locale"})
    public DateOperation(int numArgs, Fields fieldDeclaration, String dateFormatString, TimeZone zone, Locale locale) {
        super(numArgs, fieldDeclaration);
        this.dateFormatString = dateFormatString;
        this.zone = zone;
        this.locale = locale;
    }

    public String getDateFormatString() {
        return this.dateFormatString;
    }

    public SimpleDateFormat getDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.dateFormatString, this.getLocale());
        dateFormat.setTimeZone(this.getZone());
        return dateFormat;
    }

    private Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return Locale.getDefault();
    }

    private TimeZone getZone() {
        if (this.zone != null) {
            return this.zone;
        }
        return TimeZone.getTimeZone("UTC");
    }

    protected Calendar getCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("UTC"), this.getLocale());
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Pair<SimpleDateFormat, Tuple>> operationCall) {
        operationCall.setContext(new Pair<SimpleDateFormat, Tuple>(this.getDateFormat(), Tuple.size(1)));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DateOperation)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DateOperation that = (DateOperation)object;
        if (this.dateFormatString != null ? !this.dateFormatString.equals(that.dateFormatString) : that.dateFormatString != null) {
            return false;
        }
        if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) {
            return false;
        }
        return !(this.zone != null ? !this.zone.equals(that.zone) : that.zone != null);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.zone != null ? this.zone.hashCode() : 0);
        result2 = 31 * result2 + (this.locale != null ? this.locale.hashCode() : 0);
        result2 = 31 * result2 + (this.dateFormatString != null ? this.dateFormatString.hashCode() : 0);
        return result2;
    }
}

