/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.state;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Filter;
import cascading.operation.FilterCall;
import java.beans.ConstructorProperties;

public class Counter
extends BaseOperation
implements Filter {
    private final Enum counterEnum;
    private final String groupString;
    private final String counterString;
    private final int increment;

    @ConstructorProperties(value={"counter"})
    public Counter(Enum counter2) {
        this(counter2, 1);
    }

    @ConstructorProperties(value={"counter", "increment"})
    public Counter(Enum counter2, int increment) {
        this.counterEnum = counter2;
        this.groupString = null;
        this.counterString = null;
        this.increment = increment;
    }

    @ConstructorProperties(value={"group", "counter"})
    public Counter(String group2, String counter2) {
        this(group2, counter2, 1);
    }

    @ConstructorProperties(value={"group", "counter", "increment"})
    public Counter(String group2, String counter2, int increment) {
        this.counterEnum = null;
        this.groupString = group2;
        this.counterString = counter2;
        this.increment = increment;
    }

    public Enum getCounterEnum() {
        return this.counterEnum;
    }

    public String getGroupString() {
        return this.groupString;
    }

    public String getCounterString() {
        return this.counterString;
    }

    public int getIncrement() {
        return this.increment;
    }

    public boolean isRemove(FlowProcess flowProcess, FilterCall filterCall) {
        if (this.counterEnum != null) {
            flowProcess.increment(this.counterEnum, this.increment);
        } else {
            flowProcess.increment(this.groupString, this.counterString, this.increment);
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Counter)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Counter counter2 = (Counter)object;
        if (this.increment != counter2.increment) {
            return false;
        }
        if (this.counterEnum != null ? !this.counterEnum.equals(counter2.counterEnum) : counter2.counterEnum != null) {
            return false;
        }
        if (this.counterString != null ? !this.counterString.equals(counter2.counterString) : counter2.counterString != null) {
            return false;
        }
        return !(this.groupString != null ? !this.groupString.equals(counter2.groupString) : counter2.groupString != null);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.counterEnum != null ? this.counterEnum.hashCode() : 0);
        result2 = 31 * result2 + (this.groupString != null ? this.groupString.hashCode() : 0);
        result2 = 31 * result2 + (this.counterString != null ? this.counterString.hashCode() : 0);
        result2 = 31 * result2 + this.increment;
        return result2;
    }
}

