/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.regex;

import cascading.flow.FlowProcess;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.operation.regex.RegexOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.util.Pair;
import java.beans.ConstructorProperties;
import java.util.regex.Pattern;

public class RegexSplitter
extends RegexOperation<Pair<Pattern, Tuple>>
implements Function<Pair<Pattern, Tuple>> {
    private final int length;

    @ConstructorProperties(value={"patternString"})
    public RegexSplitter(String patternString) {
        super(1, patternString);
        this.length = this.fieldDeclaration.isUnknown() ? -1 : this.fieldDeclaration.size();
    }

    @ConstructorProperties(value={"fieldDeclaration"})
    public RegexSplitter(Fields fieldDeclaration) {
        super(1, fieldDeclaration, "\t");
        this.length = fieldDeclaration.isUnknown() ? -1 : fieldDeclaration.size();
    }

    @ConstructorProperties(value={"fieldDeclaration", "patternString"})
    public RegexSplitter(Fields fieldDeclaration, String patternString) {
        super(1, fieldDeclaration, patternString);
        this.length = fieldDeclaration.isUnknown() ? -1 : fieldDeclaration.size();
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Pair<Pattern, Tuple>> operationCall) {
        operationCall.setContext(new Pair<Pattern, Tuple>(this.getPattern(), new Tuple()));
    }

    @Override
    public void operate(FlowProcess flowProcess, FunctionCall<Pair<Pattern, Tuple>> functionCall) {
        String value2 = functionCall.getArguments().getString(Integer.valueOf(0));
        if (value2 == null) {
            value2 = "";
        }
        Tuple output = (Tuple)((Pair)functionCall.getContext()).getRhs();
        output.clear();
        String[] split2 = ((Pattern)((Pair)functionCall.getContext()).getLhs()).split(value2, this.length);
        for (int i = 0; i < split2.length; ++i) {
            output.add((Comparable)((Object)split2[i]));
        }
        functionCall.getOutputCollector().add(output);
    }
}

