/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.regex;

import cascading.flow.FlowProcess;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.operation.regex.RegexOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.util.Pair;
import java.beans.ConstructorProperties;
import java.util.regex.Matcher;

public class RegexReplace
extends RegexOperation<Pair<Matcher, Tuple>>
implements Function<Pair<Matcher, Tuple>> {
    private final String replacement;
    private boolean replaceAll = true;

    @ConstructorProperties(value={"fieldDeclaration", "patternString", "replacement", "replaceAll"})
    public RegexReplace(Fields fieldDeclaration, String patternString, String replacement, boolean replaceAll) {
        this(fieldDeclaration, patternString, replacement);
        this.replaceAll = replaceAll;
    }

    @ConstructorProperties(value={"fieldDeclaration", "patternString", "replacement"})
    public RegexReplace(Fields fieldDeclaration, String patternString, String replacement) {
        super(1, fieldDeclaration, patternString);
        this.replacement = replacement;
    }

    @Property(name="replacement", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="The string replacement value.")
    public String getReplacement() {
        return this.replacement;
    }

    @Property(name="replaceAll", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="Will replace all occurrences of pattern.")
    public boolean isReplaceAll() {
        return this.replaceAll;
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Pair<Matcher, Tuple>> operationCall) {
        operationCall.setContext(new Pair<Matcher, Tuple>(this.getPattern().matcher(""), Tuple.size(1)));
    }

    @Override
    public void operate(FlowProcess flowProcess, FunctionCall<Pair<Matcher, Tuple>> functionCall) {
        String value2 = functionCall.getArguments().getString(Integer.valueOf(0));
        if (value2 == null) {
            value2 = "";
        }
        Tuple output = (Tuple)((Pair)functionCall.getContext()).getRhs();
        Matcher matcher2 = ((Matcher)((Pair)functionCall.getContext()).getLhs()).reset(value2);
        if (this.replaceAll) {
            output.set(0, matcher2.replaceAll(this.replacement));
        } else {
            output.set(0, matcher2.replaceFirst(this.replacement));
        }
        functionCall.getOutputCollector().add(output);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RegexReplace)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RegexReplace that = (RegexReplace)object;
        if (this.replaceAll != that.replaceAll) {
            return false;
        }
        return !(this.replacement != null ? !this.replacement.equals(that.replacement) : that.replacement != null);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.replacement != null ? this.replacement.hashCode() : 0);
        result2 = 31 * result2 + (this.replaceAll ? 1 : 0);
        return result2;
    }
}

