/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.regex;

import cascading.flow.FlowProcess;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.operation.OperationException;
import cascading.operation.regex.RegexOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.util.Pair;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.regex.Matcher;

public class RegexParser
extends RegexOperation<Pair<Matcher, Tuple>>
implements Function<Pair<Matcher, Tuple>> {
    private int[] groups = null;

    @ConstructorProperties(value={"patternString"})
    public RegexParser(String patternString) {
        super(1, patternString);
    }

    @ConstructorProperties(value={"fieldDeclaration", "patternString"})
    public RegexParser(Fields fieldDeclaration, String patternString) {
        super(1, fieldDeclaration, patternString);
    }

    @ConstructorProperties(value={"patternString", "groups"})
    public RegexParser(String patternString, int[] groups) {
        super(1, Fields.size(RegexParser.verifyReturnLength(groups)), patternString);
        this.groups = Arrays.copyOf(groups, groups.length);
    }

    private static int verifyReturnLength(int[] groups) {
        if (groups == null || groups.length == 0) {
            throw new IllegalArgumentException("groups may not be null or 0 length");
        }
        return groups.length;
    }

    @ConstructorProperties(value={"fieldDeclaration", "patternString", "groups"})
    public RegexParser(Fields fieldDeclaration, String patternString, int[] groups) {
        super(1, fieldDeclaration, patternString);
        RegexParser.verifyReturnLength(groups);
        this.groups = Arrays.copyOf(groups, groups.length);
        if (!fieldDeclaration.isUnknown() && fieldDeclaration.size() != groups.length) {
            throw new IllegalArgumentException("fieldDeclaration must equal number of groups to be captured, fields: " + fieldDeclaration.print());
        }
    }

    public int[] getGroups() {
        if (this.groups == null) {
            return null;
        }
        return Arrays.copyOf(this.groups, this.groups.length);
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Pair<Matcher, Tuple>> operationCall) {
        operationCall.setContext(new Pair<Matcher, Tuple>(this.getPattern().matcher(""), new Tuple()));
    }

    @Override
    public void operate(FlowProcess flowProcess, FunctionCall<Pair<Matcher, Tuple>> functionCall) {
        Matcher matcher2;
        String value2 = functionCall.getArguments().getString(Integer.valueOf(0));
        if (value2 == null) {
            value2 = "";
        }
        if (!(matcher2 = ((Matcher)((Pair)functionCall.getContext()).getLhs()).reset(value2)).find()) {
            throw new OperationException("could not match pattern: [" + this.getPatternString() + "] with value: [" + value2 + "]");
        }
        Tuple output = (Tuple)((Pair)functionCall.getContext()).getRhs();
        output.clear();
        if (this.groups != null) {
            this.onGivenGroups(functionCall, matcher2, output);
        } else {
            this.onFoundGroups(functionCall, matcher2, output);
        }
    }

    private final void onFoundGroups(FunctionCall<Pair<Matcher, Tuple>> functionCall, Matcher matcher2, Tuple output) {
        int count2 = matcher2.groupCount();
        if (count2 == 0) {
            output.add((Comparable)((Object)matcher2.group(0)));
        } else {
            for (int i = 0; i < count2; ++i) {
                output.add((Comparable)((Object)matcher2.group(i + 1)));
            }
        }
        functionCall.getOutputCollector().add(output);
    }

    private final void onGivenGroups(FunctionCall<Pair<Matcher, Tuple>> functionCall, Matcher matcher2, Tuple output) {
        for (int pos : this.groups) {
            output.add((Comparable)((Object)matcher2.group(pos)));
        }
        functionCall.getOutputCollector().add(output);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RegexParser)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RegexParser that = (RegexParser)object;
        return Arrays.equals(this.groups, that.groups);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.groups != null ? Arrays.hashCode(this.groups) : 0);
        return result2;
    }
}

