/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.regex;

import cascading.flow.FlowProcess;
import cascading.operation.OperationCall;
import cascading.operation.regex.RegexOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.beans.ConstructorProperties;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexMatcher
extends RegexOperation<Matcher> {
    private static final Logger LOG = LoggerFactory.getLogger(RegexMatcher.class);
    protected final boolean negateMatch;

    @ConstructorProperties(value={"patternString"})
    protected RegexMatcher(String patternString) {
        super(patternString);
        this.negateMatch = false;
    }

    @ConstructorProperties(value={"patternString", "negateMatch"})
    protected RegexMatcher(String patternString, boolean negateMatch) {
        super(patternString);
        this.negateMatch = negateMatch;
    }

    @ConstructorProperties(value={"fieldDeclaration", "patternString"})
    protected RegexMatcher(Fields fieldDeclaration, String patternString) {
        super(Integer.MAX_VALUE, fieldDeclaration, patternString);
        this.negateMatch = false;
        this.verify();
    }

    @ConstructorProperties(value={"fieldDeclaration", "patternString", "negateMatch"})
    protected RegexMatcher(Fields fieldDeclaration, String patternString, boolean negateMatch) {
        super(Integer.MAX_VALUE, fieldDeclaration, patternString);
        this.negateMatch = negateMatch;
        this.verify();
    }

    public boolean isNegateMatch() {
        return this.negateMatch;
    }

    private void verify() {
        if (this.fieldDeclaration.size() != 1) {
            throw new IllegalArgumentException("num fields in fieldDeclaration must be one, found: " + this.fieldDeclaration.printVerbose());
        }
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Matcher> operationCall) {
        operationCall.setContext(this.getPattern().matcher(""));
    }

    protected boolean matchWholeTuple(Matcher matcher2, Tuple input2) {
        matcher2.reset(input2.toString("\t", false));
        boolean matchFound = matcher2.find();
        LOG.debug("pattern: {}, matches: {}", (Object)this.getPatternString(), (Object)matchFound);
        return matchFound == this.negateMatch;
    }

    protected boolean matchEachElement(Matcher matcher2, Tuple input2) {
        return this.matchEachElementPos(matcher2, input2) != -1;
    }

    protected int matchEachElementPos(Matcher matcher2, Tuple input2) {
        int pos = 0;
        for (Object value2 : input2) {
            if (value2 == null) {
                value2 = "";
            }
            matcher2.reset(value2.toString());
            boolean matchFound = matcher2.find();
            if (LOG.isDebugEnabled()) {
                LOG.debug("pattern: " + this.getPatternString() + ", matches: " + matchFound + ", element: '" + value2 + "'");
            }
            if (matchFound == this.negateMatch) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RegexMatcher)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RegexMatcher that = (RegexMatcher)object;
        return this.negateMatch == that.negateMatch;
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.negateMatch ? 1 : 0);
        return result2;
    }
}

