/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.function;

import cascading.flow.FlowProcess;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.operation.BaseOperation;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnGroup
extends BaseOperation
implements Function {
    private static final Logger LOG = LoggerFactory.getLogger(UnGroup.class);
    private Fields groupFieldSelector;
    private Fields[] resultFieldSelectors;
    private int size = 1;

    @ConstructorProperties(value={"groupSelector", "valueSelectors"})
    public UnGroup(Fields groupSelector, Fields[] valueSelectors) {
        if (valueSelectors == null || valueSelectors.length == 1) {
            throw new IllegalArgumentException("value selectors may not be empty");
        }
        int size2 = valueSelectors[0].size();
        for (int i = 1; i < valueSelectors.length; ++i) {
            if (valueSelectors[0].size() != valueSelectors[i].size()) {
                throw new IllegalArgumentException("all value selectors must be the same size");
            }
            size2 = valueSelectors[i].size();
        }
        this.numArgs = groupSelector.size() + size2 * valueSelectors.length;
        this.groupFieldSelector = groupSelector;
        this.resultFieldSelectors = Arrays.copyOf(valueSelectors, valueSelectors.length);
        this.fieldDeclaration = Fields.size(groupSelector.size() + size2);
    }

    @ConstructorProperties(value={"fieldDeclaration", "groupSelector", "valueSelectors"})
    public UnGroup(Fields fieldDeclaration, Fields groupSelector, Fields[] valueSelectors) {
        super(fieldDeclaration);
        if (valueSelectors == null || valueSelectors.length == 1) {
            throw new IllegalArgumentException("value selectors may not be empty");
        }
        this.numArgs = groupSelector.size();
        int selectorSize = -1;
        for (Fields resultFieldSelector : valueSelectors) {
            this.numArgs += resultFieldSelector.size();
            int fieldSize = groupSelector.size() + resultFieldSelector.size();
            if (selectorSize != -1 && selectorSize != resultFieldSelector.size()) {
                throw new IllegalArgumentException("all value selectors must be the same size, and this size plus group selector size must equal the declared field size");
            }
            selectorSize = resultFieldSelector.size();
            if (fieldDeclaration.size() == fieldSize) continue;
            throw new IllegalArgumentException("all value selectors must be the same size, and this size plus group selector size must equal the declared field size");
        }
        this.groupFieldSelector = groupSelector;
        this.resultFieldSelectors = Arrays.copyOf(valueSelectors, valueSelectors.length);
    }

    @ConstructorProperties(value={"fieldDeclaration", "groupSelector", "numValues"})
    public UnGroup(Fields fieldDeclaration, Fields groupSelector, int numValues) {
        super(fieldDeclaration);
        this.groupFieldSelector = groupSelector;
        this.size = numValues;
    }

    @Property(name="ungroupFieldSelector", visibility=Visibility.PRIVATE)
    @PropertyDescription(value="The fields to un-group.")
    public Fields getGroupFieldSelector() {
        return this.groupFieldSelector;
    }

    @Property(name="resultFieldSelectors", visibility=Visibility.PRIVATE)
    @PropertyDescription(value="The result field selectors.")
    public Fields[] getResultFieldSelectors() {
        return Util.copy(this.resultFieldSelectors);
    }

    public int getSize() {
        return this.size;
    }

    public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
        if (this.resultFieldSelectors != null) {
            this.useResultSelectors(functionCall.getArguments(), functionCall.getOutputCollector());
        } else {
            this.useSize(functionCall.getArguments(), functionCall.getOutputCollector());
        }
    }

    private void useSize(TupleEntry input2, TupleEntryCollector outputCollector) {
        LOG.debug("using size: {}", (Object)this.size);
        Tuple tuple = new Tuple(input2.getTuple());
        Tuple group2 = tuple.remove(input2.getFields(), this.groupFieldSelector);
        for (int i = 0; i < tuple.size(); i += this.size) {
            Tuple result2 = new Tuple(group2);
            result2.addAll(tuple.get(Fields.offsetSelector(this.size, i).getPos()));
            outputCollector.add(result2);
        }
    }

    private void useResultSelectors(TupleEntry input2, TupleEntryCollector outputCollector) {
        LOG.debug("using result selectors: {}", (Object)this.resultFieldSelectors.length);
        for (Fields resultFieldSelector : this.resultFieldSelectors) {
            Tuple group2 = input2.selectTupleCopy(this.groupFieldSelector);
            input2.selectInto(resultFieldSelector, group2);
            outputCollector.add(group2);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UnGroup)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        UnGroup unGroup = (UnGroup)object;
        if (this.size != unGroup.size) {
            return false;
        }
        if (this.groupFieldSelector != null ? !this.groupFieldSelector.equals(unGroup.groupFieldSelector) : unGroup.groupFieldSelector != null) {
            return false;
        }
        return Arrays.equals(this.resultFieldSelectors, unGroup.resultFieldSelectors);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.groupFieldSelector != null ? this.groupFieldSelector.hashCode() : 0);
        result2 = 31 * result2 + (this.resultFieldSelectors != null ? Arrays.hashCode(this.resultFieldSelectors) : 0);
        result2 = 31 * result2 + this.size;
        return result2;
    }
}

