/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.filter;

import cascading.flow.FlowProcess;
import cascading.operation.Filter;
import cascading.operation.FilterCall;
import cascading.operation.filter.Logic;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import java.beans.ConstructorProperties;

public class Xor
extends Logic {
    @ConstructorProperties(value={"filters"})
    public Xor(Filter ... filters) {
        super(filters);
    }

    @ConstructorProperties(value={"lhsArgumentsSelector", "lhsFilter", "rhsArgumentSelector", "rhsFilter"})
    public Xor(Fields lhsArgumentSelector, Filter lhsFilter, Fields rhsArgumentSelector, Filter rhsFilter) {
        super(lhsArgumentSelector, lhsFilter, rhsArgumentSelector, rhsFilter);
    }

    @Override
    public boolean isRemove(FlowProcess flowProcess, FilterCall filterCall) {
        Logic.Context context = (Logic.Context)filterCall.getContext();
        TupleEntry lhsEntry = context.argumentEntries[0];
        TupleEntry rhsEntry = context.argumentEntries[1];
        lhsEntry.setTuple(filterCall.getArguments().selectTuple(this.argumentSelectors[0]));
        rhsEntry.setTuple(filterCall.getArguments().selectTuple(this.argumentSelectors[1]));
        boolean lhsResult = this.filters[0].isRemove(flowProcess, context.calls[0]);
        boolean rhsResult = this.filters[1].isRemove(flowProcess, context.calls[1]);
        return lhsResult != rhsResult;
    }
}

