/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.filter;

import cascading.flow.FlowProcess;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.operation.BaseOperation;
import cascading.operation.Filter;
import cascading.operation.FilterCall;
import cascading.operation.OperationCall;
import java.beans.ConstructorProperties;
import java.util.Random;

public class Sample
extends BaseOperation<Random>
implements Filter<Random> {
    private long seed = 0L;
    private double fraction = 1.0;

    @ConstructorProperties(value={"fraction"})
    public Sample(double fraction) {
        this.seed = this.makeSeed();
        this.fraction = fraction;
    }

    @ConstructorProperties(value={"seed", "fraction"})
    public Sample(long seed, double fraction) {
        this.seed = seed;
        this.fraction = fraction;
    }

    @Property(name="seed", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="The randomization seed.")
    public long getSeed() {
        return this.seed;
    }

    @Property(name="fraction", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="The fraction of tuples to be returned.")
    public double getFraction() {
        return this.fraction;
    }

    protected long makeSeed() {
        return (long)System.identityHashCode(this) * 2654435761L ^ System.currentTimeMillis();
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Random> operationCall) {
        super.prepare(flowProcess, operationCall);
        operationCall.setContext(new Random(this.seed));
    }

    @Override
    public boolean isRemove(FlowProcess flowProcess, FilterCall<Random> filterCall) {
        return !(((Random)filterCall.getContext()).nextDouble() < this.fraction);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Sample)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Sample sample2 = (Sample)object;
        if (Double.compare(sample2.fraction, this.fraction) != 0) {
            return false;
        }
        return this.seed == sample2.seed;
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (int)(this.seed ^ this.seed >>> 32);
        long temp = this.fraction != 0.0 ? Double.doubleToLongBits(this.fraction) : 0L;
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        return result2;
    }
}

