/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.filter;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.ConcreteCall;
import cascading.operation.Filter;
import cascading.operation.OperationCall;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;

public abstract class Logic
extends BaseOperation<Context>
implements Filter<Context> {
    protected final Fields[] argumentSelectors;
    protected final Filter[] filters;

    private static Filter[] filters(Filter ... filters) {
        return filters;
    }

    @ConstructorProperties(value={"filters"})
    protected Logic(Filter ... filters) {
        this.filters = filters;
        if (filters == null) {
            throw new IllegalArgumentException("given filters array must not be null");
        }
        this.argumentSelectors = new Fields[filters.length];
        Arrays.fill(this.argumentSelectors, Fields.ALL);
        this.verify();
        this.numArgs = this.getFieldsSize();
    }

    @ConstructorProperties(value={"lhsArgumentsSelector", "lhsFilter", "rhsArgumentSelector", "rhsFilter"})
    protected Logic(Fields lhsArgumentSelector, Filter lhsFilter, Fields rhsArgumentSelector, Filter rhsFilter) {
        this(Fields.fields(lhsArgumentSelector, rhsArgumentSelector), Logic.filters(lhsFilter, rhsFilter));
    }

    @ConstructorProperties(value={"argumentSelectors", "filters"})
    protected Logic(Fields[] argumentSelectors, Filter[] filters) {
        this.argumentSelectors = argumentSelectors;
        this.filters = filters;
        this.verify();
        this.numArgs = this.getFieldsSize();
    }

    public Fields[] getArgumentSelectors() {
        return Util.copy(this.argumentSelectors);
    }

    public Filter[] getFilters() {
        return Util.copy(this.filters);
    }

    protected void verify() {
        if (this.argumentSelectors == null) {
            throw new IllegalArgumentException("given argumentSelectors array must not be null");
        }
        if (this.filters == null) {
            throw new IllegalArgumentException("given filters array must not be null");
        }
        for (Fields field2 : this.argumentSelectors) {
            if (field2 == null) {
                throw new IllegalArgumentException("given argumentSelectors must not be null");
            }
            if (field2.isAll() || field2.isDefined()) continue;
            throw new IllegalArgumentException("given argumentSelectors must be ALL or 'defined' selectors, got: " + field2.print());
        }
        for (Filter filter2 : this.filters) {
            if (filter2 != null) continue;
            throw new IllegalArgumentException("given filters must not be null");
        }
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall operationCall) {
        Context context = new Context();
        context.argumentEntries = this.getArgumentEntries();
        context.calls = new ConcreteCall[this.filters.length];
        for (int i = 0; i < this.filters.length; ++i) {
            Filter filter2 = this.filters[i];
            context.calls[i] = new ConcreteCall((ConcreteCall)operationCall);
            context.calls[i].setArguments(context.argumentEntries[i]);
            context.calls[i].setArgumentFields(context.argumentEntries[i].getFields());
            filter2.prepare(flowProcess, context.calls[i]);
        }
        operationCall.setContext(context);
    }

    @Override
    public void cleanup(FlowProcess flowProcess, OperationCall operationCall) {
        Context context = (Context)operationCall.getContext();
        ConcreteCall[] calls = context.calls;
        for (int i = 0; i < this.filters.length; ++i) {
            Filter filter2 = this.filters[i];
            filter2.cleanup(flowProcess, calls[i]);
        }
        operationCall.setContext(null);
    }

    protected int getFieldsSize() {
        HashSet<Comparable> pos = new HashSet<Comparable>();
        for (Fields field2 : this.argumentSelectors) {
            if (field2.isSubstitution()) {
                return Integer.MAX_VALUE;
            }
            for (int i = 0; i < field2.size(); ++i) {
                pos.add(field2.get(i));
            }
        }
        return pos.size();
    }

    private TupleEntry[] getArgumentEntries() {
        TupleEntry[] argumentEntries = new TupleEntry[this.argumentSelectors.length];
        for (int i = 0; i < this.argumentSelectors.length; ++i) {
            Fields argumentSelector = this.argumentSelectors[i];
            argumentEntries[i] = new TupleEntry(Fields.asDeclaration(argumentSelector), true);
        }
        return argumentEntries;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Logic)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Logic logic = (Logic)object;
        if (!Arrays.equals(this.argumentSelectors, logic.argumentSelectors)) {
            return false;
        }
        return Arrays.equals(this.filters, logic.filters);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.argumentSelectors != null ? Arrays.hashCode(this.argumentSelectors) : 0);
        result2 = 31 * result2 + (this.filters != null ? Arrays.hashCode(this.filters) : 0);
        return result2;
    }

    public class Context {
        TupleEntry[] argumentEntries;
        ConcreteCall[] calls;
    }
}

