/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.expression;

import cascading.flow.FlowProcess;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.operation.BaseOperation;
import cascading.operation.OperationCall;
import cascading.operation.OperationException;
import cascading.operation.expression.ExpressionOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.Tuples;
import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.CoercibleType;
import cascading.tuple.util.TupleViews;
import cascading.util.Util;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ScriptEvaluator;

public abstract class ScriptOperation
extends BaseOperation<Context> {
    protected final String block;
    protected Class[] parameterTypes;
    protected String[] parameterNames;
    protected Class returnType = Object.class;

    public ScriptOperation(int numArgs, Fields fieldDeclaration, String block) {
        super(numArgs, fieldDeclaration);
        this.block = block;
        this.returnType = fieldDeclaration.getTypeClass(0) == null ? this.returnType : fieldDeclaration.getTypeClass(0);
    }

    public ScriptOperation(int numArgs, Fields fieldDeclaration, String block, Class returnType) {
        super(numArgs, fieldDeclaration);
        this.block = block;
        this.returnType = returnType == null ? this.returnType : returnType;
    }

    public ScriptOperation(int numArgs, Fields fieldDeclaration, String block, Class returnType, Class[] expectedTypes) {
        super(numArgs, fieldDeclaration);
        this.block = block;
        Class clazz2 = this.returnType = returnType == null ? this.returnType : returnType;
        if (expectedTypes == null) {
            throw new IllegalArgumentException("expectedTypes may not be null");
        }
        this.parameterTypes = Arrays.copyOf(expectedTypes, expectedTypes.length);
    }

    public ScriptOperation(int numArgs, Fields fieldDeclaration, String block, Class returnType, String[] parameterNames, Class[] parameterTypes) {
        super(numArgs, fieldDeclaration);
        this.parameterNames = parameterNames == null ? null : Arrays.copyOf(parameterNames, parameterNames.length);
        this.block = block;
        this.returnType = returnType == null ? this.returnType : returnType;
        this.parameterTypes = Arrays.copyOf(parameterTypes, parameterTypes.length);
        if (this.getParameterNamesInternal().length != this.getParameterTypesInternal().length) {
            throw new IllegalArgumentException("parameterNames must be same length as parameterTypes");
        }
    }

    public ScriptOperation(int numArgs, String block, Class returnType) {
        super(numArgs);
        this.block = block;
        this.returnType = returnType == null ? this.returnType : returnType;
    }

    public ScriptOperation(int numArgs, String block, Class returnType, Class[] expectedTypes) {
        super(numArgs);
        this.block = block;
        Class clazz2 = this.returnType = returnType == null ? this.returnType : returnType;
        if (expectedTypes == null || expectedTypes.length == 0) {
            throw new IllegalArgumentException("expectedTypes may not be null or empty");
        }
        this.parameterTypes = Arrays.copyOf(expectedTypes, expectedTypes.length);
    }

    public ScriptOperation(int numArgs, String block, Class returnType, String[] parameterNames, Class[] parameterTypes) {
        super(numArgs);
        this.parameterNames = parameterNames == null ? null : Arrays.copyOf(parameterNames, parameterNames.length);
        this.block = block;
        this.returnType = returnType == null ? this.returnType : returnType;
        this.parameterTypes = Arrays.copyOf(parameterTypes, parameterTypes.length);
        if (this.getParameterNamesInternal().length != this.getParameterTypesInternal().length) {
            throw new IllegalArgumentException("parameterNames must be same length as parameterTypes");
        }
    }

    @Property(name="source", visibility=Visibility.PRIVATE)
    @PropertyDescription(value="The Java source to execute.")
    public String getBlock() {
        return this.block;
    }

    private boolean hasParameterNames() {
        return this.parameterNames != null;
    }

    @Property(name="parameterNames", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="The declared parameter names.")
    public String[] getParameterNames() {
        return Util.copy(this.parameterNames);
    }

    private String[] getParameterNamesInternal() {
        if (this.parameterNames != null) {
            return this.parameterNames;
        }
        try {
            this.parameterNames = this.guessParameterNames();
        }
        catch (IOException exception) {
            throw new OperationException("could not read expression: " + this.block, exception);
        }
        catch (CompileException exception) {
            throw new OperationException("could not compile expression: " + this.block, exception);
        }
        return this.parameterNames;
    }

    protected String[] guessParameterNames() throws CompileException, IOException {
        throw new OperationException("parameter names are required");
    }

    private Fields getParameterFields() {
        return this.makeFields(this.getParameterNamesInternal());
    }

    private boolean hasParameterTypes() {
        return this.parameterTypes != null;
    }

    @Property(name="parameterTypes", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="The declared parameter types.")
    public Class[] getParameterTypes() {
        return Util.copy(this.parameterTypes);
    }

    private Class[] getParameterTypesInternal() {
        if (!this.hasParameterNames()) {
            return this.parameterTypes;
        }
        if (this.hasParameterNames() && this.parameterNames.length == this.parameterTypes.length) {
            return this.parameterTypes;
        }
        if (this.parameterNames.length > 0 && this.parameterTypes.length != 1) {
            throw new IllegalStateException("wrong number of parameter types, expects: " + this.parameterNames.length);
        }
        Object[] types2 = new Class[this.parameterNames.length];
        Arrays.fill(types2, this.parameterTypes[0]);
        this.parameterTypes = types2;
        return this.parameterTypes;
    }

    protected ScriptEvaluator getEvaluator(Class returnType, String[] parameterNames, Class[] parameterTypes) {
        try {
            return new ScriptEvaluator(this.block, returnType, parameterNames, parameterTypes);
        }
        catch (CompileException exception) {
            throw new OperationException("could not compile script: " + this.block, exception);
        }
    }

    private Fields makeFields(String[] parameters) {
        Comparable[] fields2 = new Comparable[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            String parameter = parameters[i];
            fields2[i] = parameter.startsWith("$") ? this.parse(parameter) : parameter;
        }
        return new Fields(fields2);
    }

    private Comparable parse(String parameter) {
        try {
            return Integer.valueOf(Integer.parseInt(parameter.substring(1)));
        }
        catch (NumberFormatException exception) {
            return parameter;
        }
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Context> operationCall) {
        if (operationCall.getContext() == null) {
            operationCall.setContext(new Context());
        }
        Context context = operationCall.getContext();
        Fields argumentFields = operationCall.getArgumentFields();
        if (this.hasParameterNames() && this.hasParameterTypes()) {
            Context.access$002(context, this.getParameterNamesInternal());
            context.parameterFields = argumentFields.select(this.getParameterFields());
            Context.access$202(context, this.getParameterTypesInternal());
        } else if (this.hasParameterTypes()) {
            Context.access$002(context, this.toNames(argumentFields));
            context.parameterFields = argumentFields.applyTypes(this.getParameterTypesInternal());
            Context.access$202(context, this.getParameterTypesInternal());
        } else {
            Context.access$002(context, this.toNames(argumentFields));
            context.parameterFields = argumentFields;
            Context.access$202(context, argumentFields.getTypesClasses());
            if (argumentFields.isNone()) {
                Context.access$202(context, new Class[0]);
            }
            if (context.parameterTypes == null) {
                throw new IllegalArgumentException("field types may not be empty, incoming tuple stream should declare field types");
            }
        }
        Context.access$302(context, Coercions.coercibleArray(context.parameterFields));
        Context.access$402(context, new Object[context.parameterTypes.length]);
        context.scriptEvaluator = this.getEvaluator(this.getReturnType(), context.parameterNames, context.parameterTypes);
        context.intermediate = TupleViews.createNarrow(argumentFields.getPos(context.parameterFields));
        context.result = Tuple.size(1);
    }

    private String[] toNames(Fields argumentFields) {
        String[] names2 = new String[argumentFields.size()];
        for (int i = 0; i < names2.length; ++i) {
            Comparable comparable = argumentFields.get(i);
            names2[i] = comparable instanceof String ? (String)((Object)comparable) : "$" + comparable;
        }
        return names2;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    protected Object evaluate(Context context, TupleEntry input2) {
        try {
            if (context.parameterTypes.length == 0) {
                return context.scriptEvaluator.evaluate(null);
            }
            Tuple parameterTuple = TupleViews.reset(context.intermediate, input2.getTuple());
            Object[] arguments = Tuples.asArray(parameterTuple, context.parameterCoercions, context.parameterTypes, context.parameterArray);
            return context.scriptEvaluator.evaluate(arguments);
        }
        catch (InvocationTargetException exception) {
            throw new OperationException("could not evaluate expression: " + this.block, exception.getTargetException());
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ExpressionOperation)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ExpressionOperation that = (ExpressionOperation)object;
        if (this.block != null ? !this.block.equals(that.block) : that.block != null) {
            return false;
        }
        if (!Arrays.equals(this.parameterNames, that.parameterNames)) {
            return false;
        }
        return Arrays.equals(this.parameterTypes, that.parameterTypes);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.block != null ? this.block.hashCode() : 0);
        result2 = 31 * result2 + (this.parameterTypes != null ? Arrays.hashCode(this.parameterTypes) : 0);
        result2 = 31 * result2 + (this.parameterNames != null ? Arrays.hashCode(this.parameterNames) : 0);
        return result2;
    }

    public static class Context {
        private Class[] parameterTypes;
        private ScriptEvaluator scriptEvaluator;
        private Fields parameterFields;
        private CoercibleType[] parameterCoercions;
        private String[] parameterNames;
        private Object[] parameterArray;
        private Tuple intermediate;
        protected Tuple result;

        static /* synthetic */ String[] access$002(Context x0, String[] x1) {
            x0.parameterNames = x1;
            return x1;
        }

        static /* synthetic */ Class[] access$202(Context x0, Class[] x1) {
            x0.parameterTypes = x1;
            return x1;
        }

        static /* synthetic */ CoercibleType[] access$302(Context x0, CoercibleType[] x1) {
            x0.parameterCoercions = x1;
            return x1;
        }

        static /* synthetic */ Object[] access$402(Context x0, Object[] x1) {
            x0.parameterArray = x1;
            return x1;
        }
    }
}

