/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.buffer;

import cascading.flow.FlowProcess;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.operation.BaseOperation;
import cascading.operation.Buffer;
import cascading.operation.BufferCall;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import java.beans.ConstructorProperties;
import java.util.Iterator;

public class FirstNBuffer
extends BaseOperation
implements Buffer {
    private final int firstN;

    public FirstNBuffer() {
        super(Fields.ARGS);
        this.firstN = 1;
    }

    @ConstructorProperties(value={"firstN"})
    public FirstNBuffer(int firstN) {
        super(Fields.ARGS);
        this.firstN = firstN;
    }

    @ConstructorProperties(value={"fieldDeclaration"})
    public FirstNBuffer(Fields fieldDeclaration) {
        super(fieldDeclaration.size(), fieldDeclaration);
        this.firstN = 1;
    }

    @ConstructorProperties(value={"fieldDeclaration", "firstN"})
    public FirstNBuffer(Fields fieldDeclaration, int firstN) {
        super(fieldDeclaration.size(), fieldDeclaration);
        this.firstN = firstN;
    }

    @Property(name="firstN", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="The number of tuples to return.")
    public int getFirstN() {
        return this.firstN;
    }

    public void operate(FlowProcess flowProcess, BufferCall bufferCall) {
        Iterator<TupleEntry> iterator2 = bufferCall.getArgumentsIterator();
        for (int count2 = 0; count2 < this.firstN && iterator2.hasNext(); ++count2) {
            bufferCall.getOutputCollector().add(iterator2.next());
        }
    }
}

