/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.assertion;

import cascading.flow.FlowProcess;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.operation.ValueAssertion;
import cascading.operation.ValueAssertionCall;
import cascading.operation.assertion.BaseAssertion;
import cascading.tuple.TupleEntry;
import java.beans.ConstructorProperties;

public class AssertSizeEquals
extends BaseAssertion
implements ValueAssertion {
    private final int size;

    @ConstructorProperties(value={"size"})
    public AssertSizeEquals(int size2) {
        super("tuple size %s, is not equal to: %s, in tuple: %s");
        this.size = size2;
    }

    @Property(name="size", visibility=Visibility.PRIVATE)
    @PropertyDescription(value="The expected tuple size.")
    public int getSize() {
        return this.size;
    }

    public void doAssert(FlowProcess flowProcess, ValueAssertionCall assertionCall) {
        TupleEntry input2 = assertionCall.getArguments();
        if (input2.size() != this.size) {
            this.fail(input2.size(), this.size, input2.getTuple().print());
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AssertSizeEquals)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        AssertSizeEquals that = (AssertSizeEquals)object;
        return this.size == that.size;
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.size;
        return result2;
    }
}

