/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.assertion;

import cascading.flow.FlowProcess;
import cascading.operation.AssertionLevel;
import cascading.operation.PlannerLevel;
import cascading.operation.ValueAssertion;
import cascading.operation.ValueAssertionCall;
import cascading.operation.assertion.BaseAssertion;
import cascading.operation.regex.RegexMatcher;
import cascading.tuple.Tuple;
import java.beans.ConstructorProperties;
import java.util.regex.Matcher;

public class AssertMatches
extends RegexMatcher
implements ValueAssertion<Matcher> {
    private static final String message = "argument tuple: %s did not match: %s";

    @ConstructorProperties(value={"patternString"})
    public AssertMatches(String patternString) {
        super(patternString, false);
    }

    @ConstructorProperties(value={"patternString", "negateMatch"})
    public AssertMatches(String patternString, boolean negateMatch) {
        super(patternString, negateMatch);
    }

    @Override
    public boolean supportsPlannerLevel(PlannerLevel plannerLevel) {
        return plannerLevel instanceof AssertionLevel;
    }

    @Override
    public void doAssert(FlowProcess flowProcess, ValueAssertionCall<Matcher> assertionCall) {
        Tuple tuple = assertionCall.getArguments().getTuple();
        if (this.matchWholeTuple((Matcher)assertionCall.getContext(), tuple)) {
            BaseAssertion.throwFail(message, tuple.print(), this.patternString);
        }
    }
}

