/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.assertion;

import cascading.flow.FlowProcess;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.operation.ValueAssertion;
import cascading.operation.ValueAssertionCall;
import cascading.operation.assertion.BaseAssertion;
import cascading.tuple.TupleEntry;
import java.beans.ConstructorProperties;

public class AssertEqualsAll
extends BaseAssertion
implements ValueAssertion {
    private Object value;

    @ConstructorProperties(value={"value"})
    public AssertEqualsAll(Object value2) {
        super("argument '%s' value was: %s, not: %s, in tuple: %s");
        if (value2 == null) {
            throw new IllegalArgumentException("value may not be null");
        }
        this.value = value2;
    }

    @Property(name="value", visibility=Visibility.PRIVATE)
    @PropertyDescription(value="The expected value.")
    public Object getValue() {
        return this.value;
    }

    public void doAssert(FlowProcess flowProcess, ValueAssertionCall assertionCall) {
        TupleEntry input2 = assertionCall.getArguments();
        int pos = 0;
        for (Object element : input2.getTuple()) {
            if (!this.value.equals(element)) {
                this.fail(input2.getFields().get(pos), element, this.value, input2.getTuple().print());
            }
            ++pos;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AssertEqualsAll)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        AssertEqualsAll that = (AssertEqualsAll)object;
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.value != null ? this.value.hashCode() : 0);
        return result2;
    }
}

