/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.assertion;

import cascading.flow.FlowProcess;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.operation.ValueAssertion;
import cascading.operation.ValueAssertionCall;
import cascading.operation.assertion.BaseAssertion;
import cascading.tuple.Tuple;
import cascading.tuple.Tuples;
import java.beans.ConstructorProperties;
import java.util.Collection;

public class AssertEquals
extends BaseAssertion
implements ValueAssertion {
    private Tuple values;

    @ConstructorProperties(value={"values"})
    public AssertEquals(Object ... values2) {
        super(values2 == null ? 1 : values2.length, "argument tuple: %s was not equal to values: %s");
        if (values2 == null) {
            throw new IllegalArgumentException("values may not be null");
        }
        if (values2.length == 0) {
            throw new IllegalArgumentException("values may not be empty");
        }
        this.values = new Tuple(values2);
    }

    @Property(name="values", visibility=Visibility.PRIVATE)
    @PropertyDescription(value="The expected values.")
    public Collection getValues() {
        return Tuples.asCollection(this.values);
    }

    public void doAssert(FlowProcess flowProcess, ValueAssertionCall assertionCall) {
        Tuple tuple = assertionCall.getArguments().getTuple();
        if (!tuple.equals(this.values)) {
            this.fail(tuple.print(), this.values.print());
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AssertEquals)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        AssertEquals that = (AssertEquals)object;
        return !(this.values != null ? !this.values.equals(that.values) : that.values != null);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.values != null ? this.values.hashCode() : 0);
        return result2;
    }
}

