/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.aggregator;

import cascading.flow.FlowProcess;
import cascading.operation.Aggregator;
import cascading.operation.AggregatorCall;
import cascading.operation.BaseOperation;
import cascading.operation.OperationCall;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.CoercibleType;
import cascading.util.Pair;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;

public class Sum
extends BaseOperation<Pair<Double[], Tuple>>
implements Aggregator<Pair<Double[], Tuple>> {
    public static final String FIELD_NAME = "sum";
    private Type type = Double.class;
    private CoercibleType canonical;

    public Sum() {
        super(1, new Fields((Comparable)((Object)FIELD_NAME), (Type)((Object)Double.class)));
        this.canonical = Coercions.coercibleTypeFor(this.type);
    }

    @ConstructorProperties(value={"fieldDeclaration"})
    public Sum(Fields fieldDeclaration) {
        super(1, fieldDeclaration);
        if (!fieldDeclaration.isSubstitution() && fieldDeclaration.size() != 1) {
            throw new IllegalArgumentException("fieldDeclaration may only declare 1 field, got: " + fieldDeclaration.size());
        }
        if (fieldDeclaration.hasTypes()) {
            this.type = fieldDeclaration.getType(0);
        }
        this.canonical = Coercions.coercibleTypeFor(this.type);
    }

    @ConstructorProperties(value={"fieldDeclaration", "type"})
    public Sum(Fields fieldDeclaration, Class type) {
        this(fieldDeclaration.applyTypes(type));
        this.type = type;
        this.canonical = Coercions.coercibleTypeFor(this.type);
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Pair<Double[], Tuple>> operationCall) {
        operationCall.setContext(new Pair<Double[], Tuple>(new Double[]{null}, Tuple.size(1)));
    }

    @Override
    public void start(FlowProcess flowProcess, AggregatorCall<Pair<Double[], Tuple>> aggregatorCall) {
        ((Double[])((Pair)aggregatorCall.getContext()).getLhs())[0] = null;
        ((Tuple)((Pair)aggregatorCall.getContext()).getRhs()).set(0, null);
    }

    @Override
    public void aggregate(FlowProcess flowProcess, AggregatorCall<Pair<Double[], Tuple>> aggregatorCall) {
        TupleEntry arguments = aggregatorCall.getArguments();
        if (arguments.getObject(0) == null) {
            return;
        }
        Double[] sum2 = (Double[])((Pair)aggregatorCall.getContext()).getLhs();
        double value2 = sum2[0] == null ? 0.0 : sum2[0];
        sum2[0] = value2 + arguments.getDouble(Integer.valueOf(0));
    }

    @Override
    public void complete(FlowProcess flowProcess, AggregatorCall<Pair<Double[], Tuple>> aggregatorCall) {
        aggregatorCall.getOutputCollector().add(this.getResult(aggregatorCall));
    }

    protected Tuple getResult(AggregatorCall<Pair<Double[], Tuple>> aggregatorCall) {
        ((Tuple)((Pair)aggregatorCall.getContext()).getRhs()).set(0, this.canonical.canonical(((Double[])((Pair)aggregatorCall.getContext()).getLhs())[0]));
        return (Tuple)((Pair)aggregatorCall.getContext()).getRhs();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Sum)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Sum sum2 = (Sum)object;
        return !(this.type != null ? !this.type.equals(sum2.type) : sum2.type != null);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.type != null ? this.type.hashCode() : 0);
        return result2;
    }
}

