/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.aggregator;

import cascading.flow.FlowProcess;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.operation.AggregatorCall;
import cascading.operation.aggregator.ExtentBase;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.beans.ConstructorProperties;

public class First
extends ExtentBase {
    private final int firstN;

    public First() {
        super(Fields.ARGS);
        this.firstN = 1;
    }

    @ConstructorProperties(value={"firstN"})
    public First(int firstN) {
        super(Fields.ARGS);
        this.firstN = firstN;
    }

    @ConstructorProperties(value={"fieldDeclaration"})
    public First(Fields fieldDeclaration) {
        super(fieldDeclaration.size(), fieldDeclaration);
        this.firstN = 1;
    }

    @ConstructorProperties(value={"fieldDeclaration", "firstN"})
    public First(Fields fieldDeclaration, int firstN) {
        super(fieldDeclaration.size(), fieldDeclaration);
        this.firstN = firstN;
    }

    @ConstructorProperties(value={"fieldDeclaration", "ignoreTuples"})
    public First(Fields fieldDeclaration, Tuple ... ignoreTuples) {
        super(fieldDeclaration, ignoreTuples);
        this.firstN = 1;
    }

    @Property(name="firstN", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="The number of tuples to return.")
    public int getFirstN() {
        return this.firstN;
    }

    @Override
    protected void performOperation(Tuple[] context, TupleEntry entry2) {
        if (context[0] == null) {
            context[0] = new Tuple();
        }
        if (context[0].size() < this.firstN) {
            context[0].add(entry2.getTupleCopy());
        }
    }

    @Override
    public void complete(FlowProcess flowProcess, AggregatorCall<Tuple[]> aggregatorCall) {
        Tuple context = ((Tuple[])aggregatorCall.getContext())[0];
        if (context == null) {
            return;
        }
        for (Object tuple : context) {
            aggregatorCall.getOutputCollector().add((Tuple)tuple);
        }
    }
}

